/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import edu.uci.ics.jung.visualization.layout.NetworkElementAccessor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class MouseListenerTranslator<N, E>
extends MouseAdapter {
    private VisualizationViewer<N, E> vv;
    private GraphMouseListener<N> gel;

    public MouseListenerTranslator(GraphMouseListener<N> gel, VisualizationViewer<N, E> vv) {
        this.gel = gel;
        this.vv = vv;
    }

    private N getNode(Point2D point) {
        Point2D p = point;
        NetworkElementAccessor pickSupport = this.vv.getPickSupport();
        LayoutModel layoutModel = this.vv.getModel().getLayoutModel();
        Object v = null;
        if (pickSupport != null) {
            v = pickSupport.getNode(layoutModel, p.getX(), p.getY());
        }
        return (N)v;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        N v = this.getNode(e.getPoint());
        if (v != null) {
            this.gel.graphClicked(v, e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        N v = this.getNode(e.getPoint());
        if (v != null) {
            this.gel.graphPressed(v, e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        N v = this.getNode(e.getPoint());
        if (v != null) {
            this.gel.graphReleased(v, e);
        }
    }
}

