/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.TransformSupport;
import edu.uci.ics.jung.visualization.layout.NetworkElementAccessor;
import edu.uci.ics.jung.visualization.picking.PickedState;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PickingGraphMousePlugin<N, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    private static final Logger log = LoggerFactory.getLogger(PickingGraphMousePlugin.class);
    protected N node;
    protected E edge;
    protected boolean locked;
    protected int addToSelectionModifiers;
    protected Rectangle2D viewRectangle = new Rectangle2D.Float();
    protected Shape layoutTargetShape = this.viewRectangle;
    protected VisualizationServer.Paintable lensPaintable;
    protected Color lensColor = Color.cyan;
    protected Point2D deltaDown;

    public PickingGraphMousePlugin() {
        this(16, 17);
    }

    public PickingGraphMousePlugin(int selectionModifiers, int addToSelectionModifiers) {
        super(selectionModifiers);
        this.addToSelectionModifiers = addToSelectionModifiers;
        this.lensPaintable = new LensPaintable();
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    public Color getLensColor() {
        return this.lensColor;
    }

    public void setLensColor(Color lensColor) {
        this.lensColor = lensColor;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.down = e.getPoint();
        log.trace("mouse pick at screen coords {}", (Object)e.getPoint());
        this.deltaDown = this.down;
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        TransformSupport transformSupport = vv.getTransformSupport();
        LayoutModel layoutModel = vv.getModel().getLayoutModel();
        NetworkElementAccessor pickSupport = vv.getPickSupport();
        PickedState pickedNodeState = vv.getPickedNodeState();
        PickedState pickedEdgeState = vv.getPickedEdgeState();
        if (pickSupport != null && pickedNodeState != null) {
            MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
            this.updatePickingTargets(vv, multiLayerTransformer, this.down, this.down);
            Point2D layoutPoint = transformSupport.inverseTransform(vv, this.down);
            log.trace("layout coords of mouse click {}", (Object)layoutPoint);
            if (e.getModifiers() == this.modifiers) {
                this.node = pickSupport.getNode(layoutModel, layoutPoint.getX(), layoutPoint.getY());
                log.trace("mousePressed set the node to {}", this.node);
                if (this.node != null) {
                    if (!pickedNodeState.isPicked(this.node)) {
                        pickedNodeState.clear();
                        pickedNodeState.pick(this.node, true);
                    }
                } else {
                    this.edge = pickSupport.getEdge(layoutModel, layoutPoint);
                    if (this.edge != null) {
                        pickedEdgeState.clear();
                        pickedEdgeState.pick(this.edge, true);
                    } else {
                        vv.addPostRenderPaintable(this.lensPaintable);
                        pickedEdgeState.clear();
                        pickedNodeState.clear();
                    }
                }
            } else if (e.getModifiers() == this.addToSelectionModifiers) {
                vv.addPostRenderPaintable(this.lensPaintable);
                this.node = pickSupport.getNode(layoutModel, layoutPoint.getX(), layoutPoint.getY());
                log.trace("mousePressed with add set the node to {}", this.node);
                if (this.node != null) {
                    boolean wasThere = pickedNodeState.pick(this.node, !pickedNodeState.isPicked(this.node));
                    if (wasThere) {
                        log.trace("already, so now node will be null");
                        this.node = null;
                    }
                } else {
                    this.edge = pickSupport.getEdge(layoutModel, layoutPoint);
                    if (this.edge != null) {
                        pickedEdgeState.pick(this.edge, !pickedEdgeState.isPicked(this.edge));
                    }
                }
            }
        }
        if (this.node != null) {
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        java.awt.Point out = e.getPoint();
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        vv.getNodeSpatial().setActive(true);
        vv.getEdgeSpatial().setActive(true);
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        if (e.getModifiers() == this.modifiers) {
            if (this.down != null && this.node == null && !this.heyThatsTooClose(this.down, out, 5.0)) {
                this.pickContainedNodes(vv, this.layoutTargetShape, true);
            }
        } else if (e.getModifiers() == this.addToSelectionModifiers && this.down != null && this.node == null && !this.heyThatsTooClose(this.down, out, 5.0)) {
            this.pickContainedNodes(vv, this.layoutTargetShape, false);
        }
        log.trace("down:{} out:{}", (Object)this.down, (Object)out);
        if (this.node != null && !this.down.equals(out)) {
            Point2D graphPoint = multiLayerTransformer.inverseTransform(out);
            log.trace("p in graph coords is {}", (Object)graphPoint);
            Point2D graphDown = multiLayerTransformer.inverseTransform(this.deltaDown);
            log.trace("graphDown (down in graph coords) is {}", (Object)graphDown);
            VisualizationModel visualizationModel = vv.getModel();
            LayoutModel layoutModel = visualizationModel.getLayoutModel();
            double dx = graphPoint.getX() - graphDown.getX();
            double dy = graphPoint.getY() - graphDown.getY();
            log.trace("dx, dy: {},{}", (Object)dx, (Object)dy);
            PickedState ps = vv.getPickedNodeState();
            for (Object v : ps.getPicked()) {
                Point vp = (Point)layoutModel.apply(v);
                vp = Point.of((double)(vp.x + dx), (double)(vp.y + dy));
                layoutModel.set(v, vp);
            }
            this.deltaDown = out;
        }
        this.down = null;
        this.node = null;
        this.edge = null;
        this.viewRectangle.setFrame(0.0, 0.0, 0.0, 0.0);
        this.layoutTargetShape = multiLayerTransformer.inverseTransform(this.viewRectangle);
        vv.removePostRenderPaintable(this.lensPaintable);
        vv.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        log.trace("mouseDragged");
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        vv.getNodeSpatial().setActive(false);
        vv.getEdgeSpatial().setActive(false);
        if (!this.locked) {
            MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
            java.awt.Point p = e.getPoint();
            log.trace("view p for drag event is {}", (Object)p);
            log.trace("down is {}", (Object)this.down);
            if (this.node != null) {
                Point2D graphPoint = multiLayerTransformer.inverseTransform(p);
                log.trace("p in graph coords is {}", (Object)graphPoint);
                Point2D graphDown = multiLayerTransformer.inverseTransform(this.deltaDown);
                log.trace("graphDown (down in graph coords) is {}", (Object)graphDown);
                VisualizationModel visualizationModel = vv.getModel();
                LayoutModel layoutModel = visualizationModel.getLayoutModel();
                double dx = graphPoint.getX() - graphDown.getX();
                double dy = graphPoint.getY() - graphDown.getY();
                log.trace("dx, dy: {},{}", (Object)dx, (Object)dy);
                PickedState ps = vv.getPickedNodeState();
                for (Object v : ps.getPicked()) {
                    Point vp = (Point)layoutModel.apply(v);
                    vp = Point.of((double)(vp.x + dx), (double)(vp.y + dy));
                    layoutModel.set(v, vp);
                }
                this.deltaDown = p;
            } else {
                java.awt.Point out = e.getPoint();
                if (e.getModifiers() == this.addToSelectionModifiers || e.getModifiers() == this.modifiers) {
                    this.updatePickingTargets(vv, multiLayerTransformer, this.down, out);
                }
            }
            if (this.node != null) {
                e.consume();
            }
            vv.repaint();
        }
    }

    private boolean heyThatsTooClose(Point2D p, Point2D q, double min) {
        return Math.abs(p.getX() - q.getX()) < min && Math.abs(p.getY() - q.getY()) < min;
    }

    protected Point2D inverseTransform(VisualizationViewer<N, E> vv, Point2D p) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        return multiLayerTransformer.inverseTransform(p);
    }

    protected Shape transform(VisualizationViewer<N, E> vv, Shape shape) {
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        return multiLayerTransformer.transform(shape);
    }

    protected void updatePickingTargets(VisualizationViewer vv, MultiLayerTransformer multiLayerTransformer, Point2D down, Point2D out) {
        log.trace("updatePickingTargets with {} to {}", (Object)down, (Object)out);
        this.viewRectangle.setFrameFromDiagonal(down, out);
        this.layoutTargetShape = multiLayerTransformer.inverseTransform(this.viewRectangle);
        if (log.isTraceEnabled()) {
            log.trace("viewRectangle {}", (Object)this.viewRectangle);
            log.trace("layoutTargetShape bounds {}", (Object)this.layoutTargetShape.getBounds());
        }
    }

    protected void pickContainedNodes(VisualizationViewer<N, E> vv, Shape pickTarget, boolean clear) {
        PickedState pickedNodeState = vv.getPickedNodeState();
        if (pickedNodeState != null) {
            if (clear) {
                pickedNodeState.clear();
            }
            NetworkElementAccessor pickSupport = vv.getPickSupport();
            LayoutModel layoutModel = vv.getModel().getLayoutModel();
            Collection picked = pickSupport.getNodes(layoutModel, pickTarget);
            for (Object v : picked) {
                pickedNodeState.pick(v, true);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    class LensPaintable
    implements VisualizationServer.Paintable {
        LensPaintable() {
        }

        @Override
        public void paint(Graphics g) {
            Color oldColor = g.getColor();
            g.setColor(PickingGraphMousePlugin.this.lensColor);
            ((Graphics2D)g).draw(PickingGraphMousePlugin.this.viewRectangle);
            g.setColor(oldColor);
        }

        @Override
        public boolean useTransform() {
            return false;
        }
    }
}

