/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import com.google.common.base.Preconditions;
import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import edu.uci.ics.jung.visualization.control.CubicCurveEdgeEffects;
import edu.uci.ics.jung.visualization.control.EdgeEffects;
import edu.uci.ics.jung.visualization.control.EdgeSupport;
import java.awt.geom.Point2D;
import java.util.function.Supplier;

public class SimpleEdgeSupport<N, E>
implements EdgeSupport<N, E> {
    protected Point2D down;
    protected EdgeEffects<N, E> edgeEffects;
    protected Supplier<E> edgeFactory;
    protected N startNode;

    public SimpleEdgeSupport(Supplier<E> edgeFactory) {
        this.edgeFactory = edgeFactory;
        this.edgeEffects = new CubicCurveEdgeEffects();
    }

    @Override
    public void startEdgeCreate(BasicVisualizationServer<N, E> vv, N startNode, Point2D startPoint) {
        this.startNode = startNode;
        this.down = startPoint;
        this.edgeEffects.startEdgeEffects(vv, startPoint, startPoint);
        if (vv.getModel().getNetwork().isDirected()) {
            this.edgeEffects.startArrowEffects(vv, startPoint, startPoint);
        }
        vv.repaint();
    }

    @Override
    public void midEdgeCreate(BasicVisualizationServer<N, E> vv, Point2D midPoint) {
        if (this.startNode != null) {
            this.edgeEffects.midEdgeEffects(vv, this.down, midPoint);
            if (vv.getModel().getNetwork().isDirected()) {
                this.edgeEffects.midArrowEffects(vv, this.down, midPoint);
            }
            vv.repaint();
        }
    }

    @Override
    public void endEdgeCreate(BasicVisualizationServer<N, E> vv, N endNode) {
        Preconditions.checkState((boolean)(vv.getModel().getNetwork() instanceof MutableNetwork), (Object)"graph must be mutable");
        if (this.startNode != null) {
            MutableNetwork graph = (MutableNetwork)vv.getModel().getNetwork();
            graph.addEdge(this.startNode, endNode, this.edgeFactory.get());
            vv.getEdgeSpatial().recalculate();
            vv.repaint();
        }
        this.startNode = null;
        this.edgeEffects.endEdgeEffects(vv);
        this.edgeEffects.endArrowEffects(vv);
    }

    @Override
    public void abort(BasicVisualizationServer<N, E> vv) {
        this.startNode = null;
        this.edgeEffects.endEdgeEffects(vv);
        this.edgeEffects.endArrowEffects(vv);
        vv.repaint();
    }

    public EdgeEffects<N, E> getEdgeEffects() {
        return this.edgeEffects;
    }

    public void setEdgeEffects(EdgeEffects<N, E> edgeEffects) {
        this.edgeEffects = edgeEffects;
    }

    public Supplier<E> getEdgeFactory() {
        return this.edgeFactory;
    }

    public void setEdgeFactory(Supplier<E> edgeFactory) {
        this.edgeFactory = edgeFactory;
    }
}

