/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicNodeRenderer<N, E>
implements Renderer.Node<N, E> {
    private static final Logger log = LoggerFactory.getLogger(BasicNodeRenderer.class);

    @Override
    public void paintNode(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, N v) {
        if (renderContext.getNodeIncludePredicate().test(v)) {
            this.paintIconForNode(renderContext, visualizationModel, v);
        }
    }

    protected Shape prepareFinalNodeShape(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, N v, int[] coords) {
        Shape shape = renderContext.getNodeShapeFunction().apply(v);
        Point p = (Point)visualizationModel.getLayoutModel().apply(v);
        log.trace("prepared a shape for " + v + " to go at " + p);
        Point2D p2d = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, new Point2D.Double(p.x, p.y));
        float x = (float)p2d.getX();
        float y = (float)p2d.getY();
        coords[0] = (int)x;
        coords[1] = (int)y;
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
        shape = xform.createTransformedShape(shape);
        return shape;
    }

    protected void paintIconForNode(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, N v) {
        GraphicsDecorator g = renderContext.getGraphicsContext();
        int[] coords = new int[2];
        Shape shape = this.prepareFinalNodeShape(renderContext, visualizationModel, v, coords);
        if (renderContext.getNodeIconFunction() != null) {
            Icon icon = renderContext.getNodeIconFunction().apply(v);
            if (icon != null) {
                g.draw(icon, renderContext.getScreenDevice(), shape, coords[0], coords[1]);
            } else {
                this.paintShapeForNode(renderContext, visualizationModel, v, shape);
            }
        } else {
            this.paintShapeForNode(renderContext, visualizationModel, v, shape);
        }
    }

    protected void paintShapeForNode(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, N v, Shape shape) {
        Paint drawPaint;
        GraphicsDecorator g = renderContext.getGraphicsContext();
        Paint oldPaint = g.getPaint();
        Paint fillPaint = renderContext.getNodeFillPaintFunction().apply(v);
        if (fillPaint != null) {
            g.setPaint(fillPaint);
            g.fill(shape);
            g.setPaint(oldPaint);
        }
        if ((drawPaint = renderContext.getNodeDrawPaintFunction().apply(v)) != null) {
            g.setPaint(drawPaint);
            Stroke oldStroke = g.getStroke();
            Stroke stroke = renderContext.getNodeStrokeFunction().apply(v);
            if (stroke != null) {
                g.setStroke(stroke);
            }
            g.draw(shape);
            g.setPaint(oldPaint);
            g.setStroke(oldStroke);
        }
    }
}

