/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradientNodeRenderer<N, E>
implements Renderer.Node<N, E> {
    private static final Logger log = LoggerFactory.getLogger(GradientNodeRenderer.class);
    Color colorOne;
    Color colorTwo;
    Color pickedColorOne;
    Color pickedColorTwo;
    PickedState<N> pickedState;
    boolean cyclic;

    public GradientNodeRenderer(VisualizationServer<N, ?> vv, Color colorOne, Color colorTwo, boolean cyclic) {
        this.colorOne = colorOne;
        this.colorTwo = colorTwo;
        this.cyclic = cyclic;
    }

    public GradientNodeRenderer(VisualizationServer<N, ?> vv, Color colorOne, Color colorTwo, Color pickedColorOne, Color pickedColorTwo, boolean cyclic) {
        this.colorOne = colorOne;
        this.colorTwo = colorTwo;
        this.pickedColorOne = pickedColorOne;
        this.pickedColorTwo = pickedColorTwo;
        this.pickedState = vv.getPickedNodeState();
        this.cyclic = cyclic;
    }

    @Override
    public void paintNode(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, N v) {
        if (renderContext.getNodeIncludePredicate().test(v)) {
            Shape shape = renderContext.getNodeShapeFunction().apply(v);
            LayoutModel<N> layoutModel = visualizationModel.getLayoutModel();
            Point p = (Point)layoutModel.apply(v);
            Point2D p2d = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, new Point2D.Double(p.x, p.y));
            float x = (float)p2d.getX();
            float y = (float)p2d.getY();
            AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
            shape = xform.createTransformedShape(shape);
            log.trace("prepared a shape for " + v + " to go at " + p);
            this.paintShapeForNode(renderContext, v, shape);
        }
    }

    protected void paintShapeForNode(RenderContext<N, E> renderContext, N v, Shape shape) {
        Paint drawPaint;
        GraphicsDecorator g = renderContext.getGraphicsContext();
        Paint oldPaint = g.getPaint();
        Rectangle r = shape.getBounds();
        float y2 = (float)r.getMaxY();
        if (this.cyclic) {
            y2 = (float)(r.getMinY() + r.getHeight() / 2.0);
        }
        GradientPaint fillPaint = null;
        fillPaint = this.pickedState != null && this.pickedState.isPicked(v) ? new GradientPaint((float)r.getMinX(), (float)r.getMinY(), this.pickedColorOne, (float)r.getMinX(), y2, this.pickedColorTwo, this.cyclic) : new GradientPaint((float)r.getMinX(), (float)r.getMinY(), this.colorOne, (float)r.getMinX(), y2, this.colorTwo, this.cyclic);
        if (fillPaint != null) {
            g.setPaint(fillPaint);
            g.fill(shape);
            g.setPaint(oldPaint);
        }
        if ((drawPaint = renderContext.getNodeDrawPaintFunction().apply(v)) != null) {
            g.setPaint(drawPaint);
        }
        Stroke oldStroke = g.getStroke();
        Stroke stroke = renderContext.getNodeStrokeFunction().apply(v);
        if (stroke != null) {
            g.setStroke(stroke);
        }
        g.draw(shape);
        g.setPaint(oldPaint);
        g.setStroke(oldStroke);
    }
}

