/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Network;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.shape.TransformingGraphics;
import edu.uci.ics.jung.visualization.util.Context;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class ReshapingEdgeRenderer<N, E>
extends BasicEdgeRenderer<N, E>
implements Renderer.Edge<N, E> {
    @Override
    protected void drawSimpleEdge(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, E e) {
        Paint draw_paint;
        LensTransformer ht;
        RectangularShape lensShape;
        TransformingGraphics g = (TransformingGraphics)renderContext.getGraphicsContext();
        Network<N, E> graph = visualizationModel.getNetwork();
        EndpointPair endpoints = graph.incidentNodes(e);
        Object v1 = endpoints.nodeU();
        Object v2 = endpoints.nodeV();
        Point p1 = (Point)visualizationModel.getLayoutModel().apply(v1);
        Point p2 = (Point)visualizationModel.getLayoutModel().apply(v2);
        Point2D p12d = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, new Point2D.Double(p1.x, p1.y));
        Point2D p22d = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, new Point2D.Double(p2.x, p2.y));
        float x1 = (float)p12d.getX();
        float y1 = (float)p12d.getY();
        float x2 = (float)p22d.getX();
        float y2 = (float)p22d.getY();
        float flatness = 0.0f;
        MutableTransformer transformer = renderContext.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW);
        if (transformer instanceof LensTransformer && ((lensShape = (ht = (LensTransformer)transformer).getLens().getLensShape()).contains(x1, y1) || lensShape.contains(x2, y2))) {
            flatness = 0.05f;
        }
        boolean isLoop = v1.equals(v2);
        Shape s2 = renderContext.getNodeShapeFunction().apply(v2);
        Shape edgeShape = renderContext.getEdgeShapeFunction().apply(Context.getInstance(graph, e));
        AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
        if (isLoop) {
            Rectangle2D s2Bounds = s2.getBounds2D();
            xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
            xform.translate(0.0, -edgeShape.getBounds2D().getWidth() / 2.0);
        } else {
            float dx = x2 - x1;
            float dy = y2 - y1;
            float thetaRadians = (float)Math.atan2(dy, dx);
            xform.rotate(thetaRadians);
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            xform.scale(dist, 1.0);
        }
        edgeShape = xform.createTransformedShape(edgeShape);
        Paint oldPaint = g.getPaint();
        Paint fill_paint = renderContext.getEdgeFillPaintFunction().apply(e);
        if (fill_paint != null) {
            g.setPaint(fill_paint);
            g.fill(edgeShape, flatness);
        }
        if ((draw_paint = renderContext.getEdgeDrawPaintFunction().apply(e)) != null) {
            g.setPaint(draw_paint);
            g.draw(edgeShape, flatness);
        }
        float scalex = (float)g.getTransform().getScaleX();
        float scaley = (float)g.getTransform().getScaleY();
        if ((double)scalex < 0.3 || (double)scaley < 0.3) {
            return;
        }
        if (renderContext.renderEdgeArrow()) {
            Shape destNodeShape = renderContext.getNodeShapeFunction().apply(v2);
            AffineTransform xf = AffineTransform.getTranslateInstance(x2, y2);
            destNodeShape = xf.createTransformedShape(destNodeShape);
            AffineTransform at = this.edgeArrowRenderingSupport.getArrowTransform(renderContext, new GeneralPath(edgeShape), destNodeShape);
            if (at == null) {
                return;
            }
            Shape arrow = renderContext.getEdgeArrow();
            arrow = at.createTransformedShape(arrow);
            g.setPaint(renderContext.getArrowFillPaintFunction().apply(e));
            g.fill(arrow);
            g.setPaint(renderContext.getArrowDrawPaintFunction().apply(e));
            g.draw(arrow);
            if (!graph.isDirected()) {
                Shape nodeShape = renderContext.getNodeShapeFunction().apply(v1);
                xf = AffineTransform.getTranslateInstance(x1, y1);
                nodeShape = xf.createTransformedShape(nodeShape);
                at = this.edgeArrowRenderingSupport.getReverseArrowTransform(renderContext, new GeneralPath(edgeShape), nodeShape, !isLoop);
                if (at == null) {
                    return;
                }
                arrow = renderContext.getEdgeArrow();
                arrow = at.createTransformedShape(arrow);
                g.setPaint(renderContext.getArrowFillPaintFunction().apply(e));
                g.fill(arrow);
                g.setPaint(renderContext.getArrowDrawPaintFunction().apply(e));
                g.draw(arrow);
            }
        }
        if (draw_paint == null) {
            g.setPaint(oldPaint);
        }
        g.setPaint(oldPaint);
    }
}

