/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.spatial;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.util.LayoutChangeListener;
import edu.uci.ics.jung.layout.util.LayoutEvent;
import edu.uci.ics.jung.layout.util.LayoutNetworkEvent;
import edu.uci.ics.jung.visualization.spatial.AbstractSpatial;
import edu.uci.ics.jung.visualization.spatial.Spatial;
import edu.uci.ics.jung.visualization.spatial.TreeNode;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialQuadTree<N>
extends AbstractSpatial<N, N>
implements TreeNode,
Spatial<N>,
LayoutChangeListener<N> {
    private static final Logger log = LoggerFactory.getLogger(SpatialQuadTree.class);
    private final Object lock = new Object();
    private int MAX_OBJECTS = 1;
    private int MAX_LEVELS = 12;
    private int level;
    private Set<N> nodes;
    private Rectangle2D area;
    private Map<Quadrant, SpatialQuadTree<N>> children;
    private List<Spatial> gridCache;

    @Override
    public Rectangle2D getBounds() {
        return this.rectangle;
    }

    @Override
    public Collection<? extends TreeNode> getChildren() {
        return this.children.values();
    }

    public SpatialQuadTree(LayoutModel<N> layoutModel) {
        this(layoutModel, 0, 0.0, 0.0, layoutModel.getWidth(), layoutModel.getHeight());
    }

    public SpatialQuadTree(LayoutModel<N> layoutModel, double width, double height) {
        this(layoutModel, 0, 0.0, 0.0, width, height);
    }

    public SpatialQuadTree(LayoutModel<N> layoutModel, int level, double x, double y, double width, double height) {
        this(layoutModel, level, new Rectangle2D.Double(x, y, width, height));
    }

    public SpatialQuadTree(LayoutModel<N> layoutModel, int pLevel, Rectangle2D area) {
        super(layoutModel);
        this.level = pLevel;
        this.nodes = Collections.synchronizedSet(Sets.newHashSet());
        this.area = area;
    }

    public SpatialQuadTree<N> setMaxObjects(int o) {
        this.MAX_OBJECTS = o;
        return this;
    }

    public SpatialQuadTree<N> setMaxLevels(int l) {
        this.MAX_LEVELS = l;
        return this;
    }

    protected int getLevel() {
        return this.level;
    }

    public Set<N> getNodes() {
        return this.nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.nodes.clear();
        Object object = this.lock;
        synchronized (object) {
            this.children = null;
            this.gridCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void split() {
        log.trace("splitting {}", (Object)this);
        double width = this.area.getWidth() / 2.0;
        double height = this.area.getHeight() / 2.0;
        double x = this.area.getX();
        double y = this.area.getY();
        int childLevel = this.level + 1;
        SpatialQuadTree<N> ne = new SpatialQuadTree<N>(this.layoutModel, childLevel, x + width, y, width, height);
        SpatialQuadTree<N> nw = new SpatialQuadTree<N>(this.layoutModel, childLevel, x, y, width, height);
        SpatialQuadTree<N> sw = new SpatialQuadTree<N>(this.layoutModel, childLevel, x, y + height, width, height);
        SpatialQuadTree<N> se = new SpatialQuadTree<N>(this.layoutModel, childLevel, x + width, y + height, width, height);
        Object object = this.lock;
        synchronized (object) {
            this.children = ImmutableMap.of((Object)((Object)Quadrant.NE), ne, (Object)((Object)Quadrant.NW), nw, (Object)((Object)Quadrant.SW), sw, (Object)((Object)Quadrant.SE), se);
        }
    }

    protected Quadrant getQuadrant(Point p) {
        return this.getQuadrant(p.x, p.y);
    }

    protected Quadrant getQuadrant(double x, double y) {
        boolean inEast;
        boolean inWest;
        double centerX = this.area.getCenterX();
        double centerY = this.area.getCenterY();
        boolean inNorth = y < centerY;
        boolean inSouth = y >= centerY;
        boolean bl = inWest = x < centerX;
        if (inNorth && inWest) {
            return Quadrant.NW;
        }
        if (inSouth && inWest) {
            return Quadrant.SW;
        }
        boolean bl2 = inEast = x >= centerX;
        if (inNorth && inEast) {
            return Quadrant.NE;
        }
        if (inSouth && inEast) {
            return Quadrant.SE;
        }
        return null;
    }

    protected void insert(N p) {
        Quadrant quadrant;
        this.gridCache = null;
        log.trace("{} inserting {} at {}", new Object[]{this, p, this.layoutModel.apply(p)});
        if (this.children != null && (quadrant = this.getQuadrant((Point)this.layoutModel.apply(p))) != null && this.children.get((Object)quadrant) != null) {
            this.children.get((Object)quadrant).insert(p);
            return;
        }
        this.nodes.add(p);
        if (this.nodes.size() > this.MAX_OBJECTS && this.level < this.MAX_LEVELS) {
            this.split();
            Iterator<N> iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                N node = iterator.next();
                Quadrant quadrant2 = this.getQuadrant((Point)this.layoutModel.apply(node));
                this.children.get((Object)quadrant2).insert(node);
                iterator.remove();
            }
        }
    }

    protected Set<N> retrieve(Set<N> returnObjects, Rectangle2D r) {
        if (this.children == null) {
            returnObjects.addAll(this.nodes);
        } else {
            for (Map.Entry<Quadrant, SpatialQuadTree<N>> entry : this.children.entrySet()) {
                if (!entry.getValue().area.intersects(r)) continue;
                this.children.get((Object)entry.getKey()).retrieve(returnObjects, r);
            }
        }
        return returnObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<N> retrieve(Set<N> returnObjects, Shape shape) {
        if (this.children == null) {
            returnObjects.addAll(this.nodes);
        } else {
            Object object = this.lock;
            synchronized (object) {
                for (Map.Entry<Quadrant, SpatialQuadTree<N>> entry : this.children.entrySet()) {
                    if (!shape.intersects(entry.getValue().area)) continue;
                    this.children.get((Object)entry.getKey()).retrieve(returnObjects, shape);
                }
            }
        }
        return returnObjects;
    }

    public List<Spatial> getNodes(List<Spatial> list) {
        if (this.gridCache == null) {
            list.addAll(this.collectNodes(list, this));
            this.gridCache = list;
        }
        return this.gridCache;
    }

    @Override
    public List<Shape> getGrid() {
        ArrayList areas = Lists.newArrayList();
        return this.collectGrids(areas, this);
    }

    private List<Shape> collectGrids(List<Shape> list, SpatialQuadTree<N> tree) {
        list.add(tree.area);
        if (tree.children != null) {
            for (Map.Entry<Quadrant, SpatialQuadTree<N>> entry : tree.children.entrySet()) {
                this.collectGrids(list, entry.getValue());
            }
        }
        return list;
    }

    private List<Spatial> collectNodes(List<Spatial> list, SpatialQuadTree<N> tree) {
        list.add(tree);
        if (tree.children != null) {
            for (Map.Entry<Quadrant, SpatialQuadTree<N>> entry : tree.children.entrySet()) {
                this.collectNodes(list, entry.getValue());
            }
        }
        return list;
    }

    @Override
    public Set<N> getVisibleElements(Shape shape) {
        if (!this.isActive()) {
            log.trace("not active so getting from the graph");
            return this.layoutModel.getGraph().nodes();
        }
        this.pickShapes.add(shape);
        HashSet set = Sets.newHashSet();
        Set<N> visibleNodes = this.retrieve(set, shape);
        if (log.isDebugEnabled()) {
            log.debug("visibleNodes:{}", visibleNodes);
        }
        return visibleNodes;
    }

    public Set<N> getVisibleNodes(Rectangle2D r) {
        if (!this.isActive()) {
            log.trace("not active so getting from the graph");
            return this.layoutModel.getGraph().nodes();
        }
        HashSet set = Sets.newHashSet();
        Set<N> visibleNodes = this.retrieve(set, r);
        if (log.isDebugEnabled()) {
            log.debug("visibleNodes:{}", visibleNodes);
        }
        return visibleNodes;
    }

    @Override
    public Rectangle2D getLayoutArea() {
        return this.area;
    }

    @Override
    public void recalculate() {
        if (this.isActive()) {
            this.recalculate(this.layoutModel.getGraph().nodes());
        }
    }

    private void recalculate(Collection<N> nodes) {
        this.clear();
        while (true) {
            try {
                for (N node : nodes) {
                    this.insert(node);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    public TreeNode getContainingQuadTreeLeaf(N node) {
        if (this.nodes.contains(node)) {
            if (log.isTraceEnabled()) {
                log.trace("nodes {} in {} does contain {}", new Object[]{this.nodes, this, node});
            }
            return this;
        }
        if (this.children != null) {
            for (Map.Entry<Quadrant, SpatialQuadTree<N>> entry : this.children.entrySet()) {
                SpatialQuadTree<N> child = entry.getValue();
                TreeNode leaf = child.getContainingQuadTreeLeaf(node);
                if (leaf == null) continue;
                return leaf;
            }
        }
        return null;
    }

    @Override
    public Set<SpatialQuadTree<N>> getContainingLeafs(Point2D p) {
        return Collections.singleton(this.getContainingQuadTreeLeaf(p));
    }

    @Override
    public Set<SpatialQuadTree<N>> getContainingLeafs(double x, double y) {
        return Collections.singleton(this.getContainingQuadTreeLeaf(x, y));
    }

    @Override
    public TreeNode getContainingLeaf(Object element) {
        return this.getContainingQuadTreeLeaf(element);
    }

    public SpatialQuadTree<N> getContainingQuadTreeLeaf(Point2D p) {
        return this.getContainingQuadTreeLeaf(p.getX(), p.getY());
    }

    public SpatialQuadTree<N> getContainingQuadTreeLeaf(double x, double y) {
        if (this.area.contains(x, y)) {
            if (this.children != null) {
                for (Map.Entry<Quadrant, SpatialQuadTree<N>> entry : this.children.entrySet()) {
                    if (!entry.getValue().area.contains(x, y)) continue;
                    return entry.getValue().getContainingQuadTreeLeaf(x, y);
                }
            } else {
                return this;
            }
        }
        return null;
    }

    @Override
    public N getClosestElement(Point2D p) {
        return this.getClosestElement(p.getY(), p.getY());
    }

    @Override
    public N getClosestElement(double x, double y) {
        if (!this.isActive()) {
            return (N)this.fallback.getNode(this.layoutModel, x, y);
        }
        SpatialQuadTree<N> leaf = this.getContainingQuadTreeLeaf(x, y);
        Rectangle2D area = leaf.getLayoutArea();
        double radius = area.getWidth();
        N closest = null;
        while (closest == null) {
            double diameter = radius * 2.0;
            Ellipse2D.Double searchArea = new Ellipse2D.Double(x - radius, y - radius, diameter, diameter);
            Set<N> nodes = this.getVisibleElements(searchArea);
            closest = this.getClosest(nodes, x, y, radius);
            if (nodes.size() >= this.layoutModel.getGraph().nodes().size()) break;
            radius *= 2.0;
        }
        return closest;
    }

    @Override
    public void setBounds(Rectangle2D bounds) {
        this.gridCache = null;
        this.area = bounds;
    }

    @Override
    public void update(N node, Point location) {
        if (this.isActive()) {
            this.gridCache = null;
            if (!this.getLayoutArea().contains(location.x, location.y)) {
                log.trace(location + " outside of spatial " + this.getLayoutArea());
                this.setBounds(this.getUnion(this.getLayoutArea(), location.x, location.y));
                this.recalculate(this.layoutModel.getGraph().nodes());
            }
            SpatialQuadTree<N> locationContainingLeaf = this.getContainingQuadTreeLeaf(location.x, location.y);
            log.trace("leaf {} contains {}", locationContainingLeaf, (Object)location);
            TreeNode nodeContainingLeaf = this.getContainingQuadTreeLeaf(node);
            log.trace("leaf {} contains node {}", (Object)nodeContainingLeaf, node);
            if (locationContainingLeaf == null) {
                log.trace("got null for leaf containing {}", (Object)location);
            }
            if (nodeContainingLeaf == null) {
                log.trace("got null for leaf containing {}", node);
            }
            if (locationContainingLeaf != null && !((Object)locationContainingLeaf).equals(nodeContainingLeaf)) {
                log.trace("time to recalculate");
                this.recalculate(this.layoutModel.getGraph().nodes());
            }
            this.insert(node);
        }
    }

    public void layoutChanged(LayoutEvent<N> evt) {
        Point location = evt.getLocation();
        Object node = evt.getNode();
        this.update((N)node, evt.getLocation());
    }

    public void layoutChanged(LayoutNetworkEvent<N> evt) {
        this.update((N)evt.getNode(), evt.getLocation());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpatialQuadTree that = (SpatialQuadTree)o;
        if (this.level != that.level) {
            return false;
        }
        if (!this.nodes.equals(that.nodes)) {
            return false;
        }
        if (!this.area.equals(that.area)) {
            return false;
        }
        return this.layoutModel.equals(that.layoutModel);
    }

    public int hashCode() {
        int result = this.level;
        result = 31 * result + this.nodes.hashCode();
        result = 31 * result + this.area.hashCode();
        result = 31 * result + this.layoutModel.hashCode();
        return result;
    }

    public String toString() {
        return "SpatialQuadTree{level=" + this.level + ", nodes=" + this.nodes + ", area=" + this.area + ", children=" + this.children + '}';
    }

    static enum Quadrant {
        NE,
        NW,
        SW,
        SE;

    }
}

