/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.spatial.rtree;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.uci.ics.jung.visualization.spatial.rtree.LeafNode;
import edu.uci.ics.jung.visualization.spatial.rtree.Node;
import edu.uci.ics.jung.visualization.spatial.rtree.Pair;
import edu.uci.ics.jung.visualization.spatial.rtree.RTreeNode;
import edu.uci.ics.jung.visualization.spatial.rtree.SplitterContext;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerNode<T>
extends RTreeNode<T>
implements Node<T> {
    private static final Logger log = LoggerFactory.getLogger(InnerNode.class);
    private Optional<Rectangle2D> bounds = Optional.empty();
    private List<Node<T>> children;
    private final boolean leafChildren;

    public static <T> InnerNode<T> create(Node<T> node) {
        return new InnerNode<T>(node);
    }

    public static <T> InnerNode<T> create(InnerNode<T> node) {
        return new InnerNode<T>(node);
    }

    public static <T> InnerNode<T> create(Collection<Node<T>> nodes) {
        return new InnerNode<T>(nodes);
    }

    InnerNode(Node<T> node) {
        node.setParent(this);
        this.updateBounds(node.getBounds());
        this.leafChildren = node instanceof LeafNode;
        this.children = Lists.newArrayList((Object[])new Node[]{node});
    }

    InnerNode(Collection<Node<T>> nodes) {
        this.children = Lists.newArrayList();
        Node<T> sample = null;
        Iterator<Node<T>> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            Node<T> node;
            sample = node = iterator.next();
            node.setParent(this);
            this.updateBounds(node.getBounds());
            this.children.add(node);
        }
        this.leafChildren = sample instanceof LeafNode;
    }

    @Override
    public boolean isLeafChildren() {
        return this.leafChildren;
    }

    public Node<T> get(int i) {
        return this.children.get(i);
    }

    public List<Node<T>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds.orElse(new Rectangle2D.Double());
    }

    @Override
    public Node<T> recalculateBounds() {
        this.bounds = Optional.empty();
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            this.updateBounds(this.children.get(i).getBounds());
        }
        if (this.parent.isPresent()) {
            return ((Node)this.parent.get()).recalculateBounds();
        }
        return this;
    }

    @Override
    public T getPickedObject(Point2D p) {
        int size;
        int i;
        T picked = null;
        if (this.getBounds().contains(p) && (i = 0) < (size = this.children.size())) {
            return this.children.get(i).getPickedObject(p);
        }
        return picked;
    }

    @Override
    public int size() {
        return this.children.size();
    }

    private Node<T> findElement(T o) {
        Node<T> found = null;
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            Node<T> kid = this.children.get(i);
            if (kid instanceof LeafNode) {
                return kid;
            }
            found = ((InnerNode)kid).findElement(o);
        }
        return found;
    }

    @Override
    public LeafNode<T> getContainingLeaf(T element) {
        LeafNode<T> containingLeaf = null;
        int size = this.children.size();
        for (int i = 0; i < size && (containingLeaf = this.children.get(i).getContainingLeaf(element)) == null; ++i) {
        }
        return containingLeaf;
    }

    LeafNode<T> getContainingLeaf(T element, Rectangle2D bounds) {
        Node<T> node;
        LeafNode<T> containingLeaf = null;
        int size = this.children.size();
        for (int i = 0; !(i >= size || (node = this.children.get(i)).getBounds().intersects(bounds) && (containingLeaf = node.getContainingLeaf(element)) != null); ++i) {
        }
        return containingLeaf;
    }

    @Override
    public Set<LeafNode<T>> getContainingLeafs(Set<LeafNode<T>> containingLeafs, Point2D p) {
        return this.getContainingLeafs(containingLeafs, p.getX(), p.getY());
    }

    @Override
    public Set<LeafNode<T>> getContainingLeafs(Set<LeafNode<T>> containingLeafs, double x, double y) {
        if (this.getBounds().contains(x, y)) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                Node<T> node = this.children.get(i);
                node.getContainingLeafs(containingLeafs, x, y);
            }
        }
        return containingLeafs;
    }

    @Override
    public Collection<Shape> collectGrids(Collection<Shape> list) {
        list.add(this.getBounds());
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            this.children.get(i).collectGrids(list);
        }
        log.trace("in nonleaf {}, added {} so list size now {}", new Object[]{this.hashCode(), this.children.size(), list.size()});
        return list;
    }

    private void add(Collection<? extends Node<T>> collection) {
        this.children.addAll(collection);
    }

    private void updateBounds(Rectangle2D r) {
        this.bounds = this.bounds.isPresent() ? Optional.of(this.bounds.get().createUnion(r)) : Optional.of(r);
        Rectangle2D b = this.bounds.get();
    }

    @Override
    public Node<T> add(SplitterContext<T> splitterContext, T element, Rectangle2D bounds) {
        this.updateBounds(bounds);
        Optional pathToFollow = splitterContext.splitter.chooseSubtree(this, element, bounds);
        if (pathToFollow.isPresent()) {
            Node node = pathToFollow.get().add(splitterContext, element, bounds);
            return node.getParent().orElse(node);
        }
        return null;
    }

    @Override
    public Node<T> remove(T element) {
        LeafNode<T> containingLeaf = this.getContainingLeaf(element);
        if (containingLeaf == null) {
            log.warn("{} is not in the tree! ", element);
            return this;
        }
        return containingLeaf.remove(element);
    }

    void addNode(Node<T> node) {
        Preconditions.checkArgument((node != this ? 1 : 0) != 0, (Object)"Attempt to add self as child");
        Preconditions.checkArgument((!this.children.contains(node) ? 1 : 0) != 0, (Object)"Attempt to add duplicate child");
        node.setParent(this);
        this.updateBounds(node.getBounds());
        this.children.add(node);
    }

    void removeNode(Node<T> node) {
        this.children.remove(node);
    }

    InnerNode<T> add(SplitterContext<T> splitterContext, Node<T> ... nodes) {
        InnerNode<T> top = this;
        for (Node<T> node : nodes) {
            top = this.add(splitterContext, node);
        }
        if (top.getParent().isPresent()) {
            return (InnerNode)top.getParent().get();
        }
        return top;
    }

    private InnerNode<T> add(SplitterContext<T> splitterContext, Node<T> node) {
        Preconditions.checkArgument((node != this ? 1 : 0) != 0, (Object)"Attempt to add self as child");
        this.updateBounds(node.getBounds());
        if (this.size() > 10) {
            log.trace("splitting InnerNode {}", (Object)this);
            Pair pair = splitterContext.splitter.split(this.children, node);
            if (this.parent.isPresent()) {
                InnerNode innerNodeParent = (InnerNode)this.parent.get();
                Preconditions.checkArgument((this != pair.left && this != pair.right ? 1 : 0) != 0, (String)"Pair left {} or right {} the same as this {}", pair.left, pair.right, (Object)this);
                innerNodeParent.removeNode(this);
                return innerNodeParent.add(splitterContext, (Node)pair.left, (Node)pair.right);
            }
            InnerNode<T> innerNodeParent = InnerNode.create((InnerNode)pair.left);
            return super.add(splitterContext, (Node<T>)((Node)pair.right));
        }
        this.addNode(node);
        return this.parent.orElse(this);
    }

    @Override
    public Set<T> getVisibleElements(Set<T> visibleElements, Shape shape) {
        if (shape.intersects(this.getBounds())) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                this.children.get(i).getVisibleElements(visibleElements, shape);
            }
        }
        log.trace("visibleElements of InnerNode inside {} are {}", (Object)shape, visibleElements);
        return visibleElements;
    }

    @Override
    public int count() {
        int count = 0;
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            count += this.children.get(i).count();
        }
        return count;
    }

    private String asString() {
        return this.asString("");
    }

    public String toString() {
        return this.asString();
    }

    @Override
    public String asString(String margin) {
        StringBuilder s = new StringBuilder();
        s.append(margin);
        s.append("InnerNode:parent:").append(this.parent.isPresent() ? "yes" : "none");
        s.append(" bounds=");
        s.append(Node.asString(this.getBounds()));
        s.append('\n');
        for (Node<T> child : this.children) {
            s.append(child.asString(margin + "   "));
        }
        return s.toString();
    }
}

