/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.subLayout;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphCollapser {
    private static final Logger logger = LoggerFactory.getLogger(GraphCollapser.class);
    private Network originalGraph;
    private NetworkBuilder graphBuilder;

    public GraphCollapser(Network originalGraph) {
        this.originalGraph = originalGraph;
        this.graphBuilder = NetworkBuilder.from((Network)originalGraph);
    }

    public Network collapse(Network inGraph, Network clusterGraph) {
        if (clusterGraph.nodes().size() < 2) {
            return inGraph;
        }
        MutableNetwork graph = this.graphBuilder.build();
        Set cluster = clusterGraph.nodes();
        for (Object v : inGraph.nodes()) {
            if (cluster.contains(v)) continue;
            graph.addNode(v);
        }
        graph.addNode((Object)clusterGraph);
        for (Object e : inGraph.edges()) {
            EndpointPair endpoints = inGraph.incidentNodes(e);
            Object u = endpoints.nodeU();
            Object v = endpoints.nodeV();
            if (cluster.contains(u) && cluster.contains(v)) continue;
            if (cluster.contains(u)) {
                graph.addEdge((Object)clusterGraph, v, e);
                continue;
            }
            if (cluster.contains(v)) {
                graph.addEdge(u, (Object)clusterGraph, e);
                continue;
            }
            graph.addEdge(u, v, e);
        }
        return graph;
    }

    public Network expand(Network originalNetwork, Network inGraph, Network clusterGraphNode) {
        EndpointPair endpoints;
        NetworkBuilder networkBuilder = NetworkBuilder.from((Network)originalNetwork);
        MutableNetwork newGraph = networkBuilder.build();
        for (Object node : inGraph.nodes()) {
            if (node.equals(clusterGraphNode) || this.contains(clusterGraphNode, node)) continue;
            newGraph.addNode(node);
        }
        for (Object edge : inGraph.edges()) {
            endpoints = inGraph.incidentNodes(edge);
            boolean dontWantThis = false;
            for (Object endpoint : endpoints) {
                dontWantThis |= endpoint.equals(clusterGraphNode) || this.contains(clusterGraphNode, endpoint);
            }
            if (dontWantThis) continue;
            newGraph.addEdge(endpoints.nodeU(), endpoints.nodeV(), edge);
        }
        for (Object node : clusterGraphNode.nodes()) {
            newGraph.addNode(node);
        }
        for (Object edge : clusterGraphNode.edges()) {
            endpoints = clusterGraphNode.incidentNodes(edge);
            newGraph.addEdge(endpoints.nodeU(), endpoints.nodeV(), edge);
        }
        for (Object edge : inGraph.edges()) {
            HashSet endpointsFromCollapsedGraph = Sets.newHashSet((Iterable)inGraph.incidentNodes(edge));
            for (Object endpoint : inGraph.incidentNodes(edge)) {
                if (!endpoint.equals(clusterGraphNode)) continue;
                HashSet endpointsFromOriginalGraph = Sets.newHashSet((Iterable)originalNetwork.incidentNodes(edge));
                endpointsFromCollapsedGraph.remove(endpoint);
                for (Object originalEndpoint : endpointsFromOriginalGraph) {
                    if (!this.contains(clusterGraphNode, originalEndpoint)) continue;
                    endpointsFromCollapsedGraph.add(originalEndpoint);
                    break;
                }
                ArrayList list = Lists.newArrayList((Iterable)endpointsFromCollapsedGraph);
                newGraph.addEdge(list.get(0), list.get(1), edge);
            }
        }
        return newGraph;
    }

    public Object findNode(Network inGraph, Object inNode) {
        if (inGraph.nodes().contains(inNode)) {
            return inNode;
        }
        for (Object node : inGraph.nodes()) {
            if (!(node instanceof Network) || !this.contains((Network)node, inNode)) continue;
            return node;
        }
        return null;
    }

    Object findOriginalNode(Network inGraph, Object inNode, Network clusterGraph) {
        if (inGraph.nodes().contains(inNode)) {
            return inNode;
        }
        for (Object node : inGraph.nodes()) {
            if (node instanceof Network && !node.equals(clusterGraph)) {
                return node;
            }
            if (!(node instanceof Network) || !this.contains((Network)node, inNode)) continue;
            return node;
        }
        return null;
    }

    public boolean contains(Network inGraph, Object inNode) {
        boolean contained = false;
        if (inGraph.nodes().contains(inNode)) {
            return true;
        }
        for (Object node : inGraph.nodes()) {
            contained |= node instanceof Network && this.contains((Network)node, inNode);
        }
        return contained;
    }

    public Network getClusterGraph(Network inGraph, Collection picked) {
        MutableNetwork clusterGraph = this.graphBuilder.build();
        for (Object node : picked) {
            clusterGraph.addNode(node);
            Set edges = inGraph.incidentEdges(node);
            for (Object edge : edges) {
                Object u = inGraph.incidentNodes(edge).nodeU();
                Object v = inGraph.incidentNodes(edge).nodeV();
                if (!picked.contains(u) || !picked.contains(v)) continue;
                clusterGraph.addEdge(u, v, edge);
            }
        }
        return clusterGraph;
    }
}

