/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.RectangularShape;

public abstract class AbstractLensSupport<N, E>
implements LensSupport {
    protected VisualizationViewer<N, E> vv;
    protected VisualizationViewer.GraphMouse graphMouse;
    protected LensTransformer lensTransformer;
    protected ModalGraphMouse lensGraphMouse;
    protected LensPaintable lensPaintable;
    protected LensControls lensControls;
    protected String defaultToolTipText;
    protected static final String instructions = "<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge to resize it<p>Ctrl+MouseWheel to change magnification</center></html>";

    public AbstractLensSupport(VisualizationViewer<N, E> vv, ModalGraphMouse lensGraphMouse) {
        this.vv = vv;
        this.graphMouse = vv.getGraphMouse();
        this.defaultToolTipText = vv.getToolTipText();
        this.lensGraphMouse = lensGraphMouse;
    }

    @Override
    public void activate(boolean state) {
        if (state) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    @Override
    public LensTransformer getLensTransformer() {
        return this.lensTransformer;
    }

    @Override
    public ModalGraphMouse getGraphMouse() {
        return this.lensGraphMouse;
    }

    public LensPaintable getLensPaintable() {
        return this.lensPaintable;
    }

    public void setLensPaintable(LensPaintable lensPaintable) {
        this.lensPaintable = lensPaintable;
    }

    public LensControls getLensControls() {
        return this.lensControls;
    }

    public void setLensControls(LensControls lensControls) {
        this.lensControls = lensControls;
    }

    public static class LensControls
    implements VisualizationServer.Paintable {
        RectangularShape lensShape;
        Paint paint = Color.gray;

        public LensControls(LensTransformer lensTransformer) {
            this.lensShape = lensTransformer.getLens().getLensShape();
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(this.paint);
            g2d.draw(this.lensShape);
            int centerX = (int)Math.round(this.lensShape.getCenterX());
            int centerY = (int)Math.round(this.lensShape.getCenterY());
            g.drawOval(centerX - 10, centerY - 10, 20, 20);
        }

        @Override
        public boolean useTransform() {
            return true;
        }
    }

    public static class LensPaintable
    implements VisualizationServer.Paintable {
        RectangularShape lensShape;
        Paint paint = Color.decode("0xdddddd");

        public LensPaintable(LensTransformer lensTransformer) {
            this.lensShape = lensTransformer.getLens().getLensShape();
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(this.paint);
            g2d.fill(this.lensShape);
        }

        @Override
        public boolean useTransform() {
            return true;
        }
    }
}

