/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.util;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Network;
import edu.uci.ics.jung.visualization.util.Context;
import edu.uci.ics.jung.visualization.util.EdgeIndexFunction;
import java.util.HashMap;
import java.util.Map;

public class ParallelEdgeIndexFunction<N, E>
implements EdgeIndexFunction<N, E> {
    protected Map<E, Integer> edge_index = new HashMap<E, Integer>();

    @Override
    public int getIndex(Context<Network<N, E>, E> context) {
        Network network = (Network)context.graph;
        Object edge = context.element;
        Integer index = this.edge_index.get(edge);
        if (index == null) {
            EndpointPair endpoints = network.incidentNodes(edge);
            Object u = endpoints.nodeU();
            Object v = endpoints.nodeV();
            int count = 0;
            for (Object connectingEdge : network.edgesConnecting(u, v)) {
                this.edge_index.put(connectingEdge, count++);
            }
            return this.edge_index.get(edge);
        }
        return index;
    }

    @Override
    public void reset(Context<Network<N, E>, E> context) {
        this.edge_index.remove(context.element);
    }

    @Override
    public void reset() {
        this.edge_index.clear();
    }
}

