/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.graph.event.NetworkEvent;
import edu.uci.ics.jung.graph.event.NetworkEventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class ObservableNetwork<N, E>
implements MutableNetwork<N, E> {
    List<NetworkEventListener<N, E>> listenerList = Collections.synchronizedList(new ArrayList());
    MutableNetwork<N, E> delegate;

    public ObservableNetwork(MutableNetwork<N, E> delegate) {
        this.delegate = (MutableNetwork)Preconditions.checkNotNull(delegate, (Object)"delegate");
    }

    public void addGraphEventListener(NetworkEventListener<N, E> l) {
        this.listenerList.add((NetworkEventListener<N, Object>)Preconditions.checkNotNull(l, (Object)"l"));
    }

    public void removeGraphEventListener(NetworkEventListener<N, E> l) {
        this.listenerList.remove(Preconditions.checkNotNull(l, (Object)"l"));
    }

    protected void fireGraphEvent(Supplier<NetworkEvent<N, E>> evtSupplier) {
        Preconditions.checkNotNull(evtSupplier, (Object)"evtSupplier");
        if (this.listenerList.isEmpty()) {
            return;
        }
        NetworkEvent<N, E> evt = evtSupplier.get();
        Preconditions.checkNotNull(evt, (Object)"evt");
        for (NetworkEventListener<N, E> listener : this.listenerList) {
            listener.handleGraphEvent(evt);
        }
    }

    public boolean addEdge(N v1, N v2, E e) {
        boolean state = this.delegate.addEdge(v1, v2, e);
        if (state) {
            this.fireGraphEvent(() -> new NetworkEvent.Edge<N, Object>(this.delegate, NetworkEvent.Type.EDGE_ADDED, e));
        }
        return state;
    }

    public boolean addNode(N node) {
        boolean state = this.delegate.addNode(node);
        if (state) {
            this.fireGraphEvent(() -> new NetworkEvent.Node<Object, E>(this.delegate, NetworkEvent.Type.NODE_ADDED, node));
        }
        return state;
    }

    public boolean removeEdge(E edge) {
        boolean state = this.delegate.removeEdge(edge);
        if (state) {
            this.fireGraphEvent(() -> new NetworkEvent.Edge<N, Object>(this.delegate, NetworkEvent.Type.EDGE_REMOVED, edge));
        }
        return state;
    }

    public boolean removeNode(N node) {
        ImmutableList incident_edges = ImmutableList.copyOf((Collection)this.delegate.incidentEdges(node));
        for (Object e : incident_edges) {
            this.removeEdge(e);
        }
        boolean state = this.delegate.removeNode(node);
        if (state) {
            this.fireGraphEvent(() -> new NetworkEvent.Node<Object, E>(this.delegate, NetworkEvent.Type.NODE_REMOVED, node));
        }
        return state;
    }

    public Set<E> adjacentEdges(E edge) {
        return this.delegate.adjacentEdges(edge);
    }

    public Set<N> adjacentNodes(N node) {
        return this.delegate.adjacentNodes(node);
    }

    public boolean allowsParallelEdges() {
        return this.delegate.allowsParallelEdges();
    }

    public boolean allowsSelfLoops() {
        return this.delegate.allowsSelfLoops();
    }

    public Graph<N> asGraph() {
        return this.delegate.asGraph();
    }

    public int degree(N node) {
        return this.delegate.degree(node);
    }

    public ElementOrder<E> edgeOrder() {
        return this.delegate.edgeOrder();
    }

    public Set<E> edges() {
        return this.delegate.edges();
    }

    public Set<E> edgesConnecting(N nodeU, N nodeV) {
        return this.delegate.edgesConnecting(nodeU, nodeV);
    }

    public Optional<E> edgeConnecting(N nodeU, N nodeV) {
        return this.delegate.edgeConnecting(nodeU, nodeV);
    }

    public E edgeConnectingOrNull(N nodeU, N nodeV) {
        return (E)this.delegate.edgeConnectingOrNull(nodeU, nodeV);
    }

    public boolean hasEdgeConnecting(N nodeU, N nodeV) {
        return this.delegate.hasEdgeConnecting(nodeU, nodeV);
    }

    public int inDegree(N node) {
        return this.delegate.inDegree(node);
    }

    public Set<E> inEdges(N node) {
        return this.delegate.inEdges(node);
    }

    public Set<E> incidentEdges(N node) {
        return this.delegate.incidentEdges(node);
    }

    public EndpointPair<N> incidentNodes(E edge) {
        return this.delegate.incidentNodes(edge);
    }

    public boolean isDirected() {
        return this.delegate.isDirected();
    }

    public ElementOrder<N> nodeOrder() {
        return this.delegate.nodeOrder();
    }

    public Set<N> nodes() {
        return this.delegate.nodes();
    }

    public int outDegree(N node) {
        return this.delegate.outDegree(node);
    }

    public Set<E> outEdges(N node) {
        return this.delegate.outEdges(node);
    }

    public Set<N> predecessors(N node) {
        return this.delegate.predecessors(node);
    }

    public Set<N> successors(N node) {
        return this.delegate.successors(node);
    }
}

