/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.event;

import com.google.common.graph.Network;

public abstract class NetworkEvent<N, E> {
    protected Network<N, E> source;
    protected Type type;

    public NetworkEvent(Network<N, E> source, Type type) {
        this.source = source;
        this.type = type;
    }

    public Network<N, E> getSource() {
        return this.source;
    }

    public Type getType() {
        return this.type;
    }

    public static class Edge<N, E>
    extends NetworkEvent<N, E> {
        protected E edge;

        public Edge(Network<N, E> source, Type type, E edge) {
            super(source, type);
            this.edge = edge;
        }

        public E getEdge() {
            return this.edge;
        }

        public String toString() {
            return "GraphEvent type:" + (Object)((Object)this.type) + " for " + this.edge;
        }
    }

    public static class Node<N, E>
    extends NetworkEvent<N, E> {
        protected N node;

        public Node(Network<N, E> source, Type type, N node) {
            super(source, type);
            this.node = node;
        }

        public N getNode() {
            return this.node;
        }

        public String toString() {
            return "GraphEvent type:" + (Object)((Object)this.type) + " for " + this.node;
        }
    }

    public static enum Type {
        NODE_ADDED,
        NODE_REMOVED,
        EDGE_ADDED,
        EDGE_REMOVED;

    }
}

