/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.util;

import com.google.common.base.Preconditions;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Network;
import edu.uci.ics.jung.graph.util.EdgeIndexFunction;
import java.util.HashMap;
import java.util.Map;

public class ParallelEdgeIndexFunction<N, E>
implements EdgeIndexFunction<E> {
    protected Map<E, Integer> edgeIndex = new HashMap<E, Integer>();
    protected Network<N, E> graph;

    public ParallelEdgeIndexFunction(Network<N, E> graph) {
        this.graph = (Network)Preconditions.checkNotNull(graph, (Object)"graph");
    }

    @Override
    public int getIndex(E edge) {
        Preconditions.checkNotNull(edge, (Object)"edge");
        Integer index = this.edgeIndex.get(edge);
        if (index == null) {
            EndpointPair endpoints = this.graph.incidentNodes(edge);
            Object u = endpoints.nodeU();
            Object v = endpoints.nodeV();
            int count = 0;
            for (Object connectingEdge : this.graph.edgesConnecting(u, v)) {
                this.edgeIndex.put(connectingEdge, count++);
            }
            return this.edgeIndex.get(edge);
        }
        return index;
    }

    @Override
    public void reset(E edge) {
        this.edgeIndex.remove(Preconditions.checkNotNull(edge, (Object)"edge"));
    }

    @Override
    public void reset() {
        this.edgeIndex.clear();
    }
}

