/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import com.google.common.graph.Network;
import edu.uci.ics.jung.layout.algorithms.LayoutAlgorithm;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class VisualizationImageServer<N, E>
extends BasicVisualizationServer<N, E> {
    Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>();

    public VisualizationImageServer(Network<N, E> network, LayoutAlgorithm<N> layoutAlgorithm, Dimension preferredSize) {
        super(network, layoutAlgorithm, preferredSize);
        this.setSize(preferredSize);
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.addNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(Point2D center, Dimension d) {
        int width = this.getWidth();
        int height = this.getHeight();
        float scalex = (float)width / (float)d.width;
        float scaley = (float)height / (float)d.height;
        try {
            this.renderContext.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW).scale(scalex, scaley, center);
            BufferedImage bi = new BufferedImage(width, height, 1);
            Graphics2D graphics = bi.createGraphics();
            graphics.setRenderingHints(this.renderingHints);
            this.paint(graphics);
            graphics.dispose();
            BufferedImage bufferedImage = bi;
            return bufferedImage;
        }
        finally {
            this.renderContext.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW).setToIdentity();
        }
    }
}

