/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.annotations;

import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.annotations.Annotation;
import edu.uci.ics.jung.visualization.annotations.AnnotationRenderer;
import edu.uci.ics.jung.visualization.transform.AffineTransformer;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;

public class AnnotationPaintable
implements VisualizationServer.Paintable {
    protected Set<Annotation> annotations = new HashSet<Annotation>();
    protected AnnotationRenderer annotationRenderer;
    protected RenderContext<?, ?> rc;
    protected AffineTransformer transformer;

    public AnnotationPaintable(RenderContext<?, ?> rc, AnnotationRenderer annotationRenderer) {
        this.rc = rc;
        this.annotationRenderer = annotationRenderer;
        MutableTransformer mt = rc.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        if (mt instanceof AffineTransformer) {
            this.transformer = (AffineTransformer)((Object)mt);
        } else if (mt instanceof LensTransformer) {
            this.transformer = (AffineTransformer)((Object)((LensTransformer)mt).getDelegate());
        }
    }

    public void add(Annotation<?> annotation) {
        this.annotations.add(annotation);
    }

    public void remove(Annotation<?> annotation) {
        this.annotations.remove(annotation);
    }

    public Set<Annotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Color oldColor = g.getColor();
        for (Annotation annotation : this.annotations) {
            Object ann = annotation.getAnnotation();
            if (ann instanceof Shape) {
                Shape shape = (Shape)ann;
                Paint paint = annotation.getPaint();
                Shape s = this.transformer.transform(shape);
                g2d.setPaint(paint);
                if (annotation.isFill()) {
                    g2d.fill(s);
                    continue;
                }
                g2d.draw(s);
                continue;
            }
            if (!(ann instanceof String)) continue;
            Point2D p = annotation.getLocation();
            String label = (String)ann;
            Component component = this.prepareRenderer(this.rc, this.annotationRenderer, label);
            component.setForeground((Color)annotation.getPaint());
            if (annotation.isFill()) {
                ((JComponent)component).setOpaque(true);
                component.setBackground((Color)annotation.getPaint());
                component.setForeground(Color.black);
            }
            Dimension d = component.getPreferredSize();
            AffineTransform old = g2d.getTransform();
            AffineTransform base = new AffineTransform(old);
            AffineTransform xform = this.transformer.getTransform();
            double rotation = this.transformer.getRotation();
            AffineTransform unrotate = AffineTransform.getRotateInstance(-rotation, p.getX(), p.getY());
            base.concatenate(xform);
            base.concatenate(unrotate);
            g2d.setTransform(base);
            this.rc.getRendererPane().paintComponent(g, component, this.rc.getScreenDevice(), (int)p.getX(), (int)p.getY(), d.width, d.height, true);
            g2d.setTransform(old);
        }
        g.setColor(oldColor);
    }

    public Component prepareRenderer(RenderContext<?, ?> rc, AnnotationRenderer annotationRenderer, Object value) {
        return annotationRenderer.getAnnotationRendererComponent(rc.getScreenDevice(), value);
    }

    @Override
    public boolean useTransform() {
        return true;
    }
}

