/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.layout.NetworkElementAccessor;
import edu.uci.ics.jung.visualization.picking.PickedState;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class AnimatedPickingGraphMousePlugin<N, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    protected N node;

    public AnimatedPickingGraphMousePlugin() {
        this(18);
    }

    public AnimatedPickingGraphMousePlugin(int selectionModifiers) {
        super(selectionModifiers);
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getModifiers() == this.modifiers) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            LayoutModel layoutModel = vv.getModel().getLayoutModel();
            NetworkElementAccessor pickSupport = vv.getPickSupport();
            PickedState pickedNodeState = vv.getPickedNodeState();
            if (pickSupport != null && pickedNodeState != null) {
                java.awt.Point p = e.getPoint();
                this.node = pickSupport.getNode(layoutModel, ((Point2D)p).getX(), ((Point2D)p).getY());
                if (this.node != null && !pickedNodeState.isPicked(this.node)) {
                    pickedNodeState.clear();
                    pickedNodeState.pick(this.node, true);
                }
            }
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getModifiers() == this.modifiers) {
            final VisualizationViewer vv = (VisualizationViewer)e.getSource();
            Point newCenter = null;
            if (this.node != null) {
                LayoutModel layoutModel = vv.getModel().getLayoutModel();
                newCenter = (Point)layoutModel.apply(this.node);
            } else {
                Point2D center = vv.getCenter();
                newCenter = Point.of((double)center.getX(), (double)center.getY());
            }
            Point2D lvc = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(vv.getCenter());
            final double dx = (lvc.getX() - newCenter.x) / 10.0;
            final double dy = (lvc.getY() - newCenter.y) / 10.0;
            Runnable animator = new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT).translate(dx, dy);
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            };
            Thread thread = new Thread(animator);
            thread.start();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }
}

