/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.EdgeSupport;
import edu.uci.ics.jung.visualization.control.NodeSupport;
import edu.uci.ics.jung.visualization.control.SimpleEdgeSupport;
import edu.uci.ics.jung.visualization.control.SimpleNodeSupport;
import edu.uci.ics.jung.visualization.layout.NetworkElementAccessor;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.function.Supplier;
import javax.swing.JComponent;

public class EditingGraphMousePlugin<N, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    protected NodeSupport<N, E> nodeSupport;
    protected EdgeSupport<N, E> edgeSupport;
    private Creating createMode = Creating.UNDETERMINED;

    public EditingGraphMousePlugin(Supplier<N> nodeFactory, Supplier<E> edgeFactory) {
        this(16, nodeFactory, edgeFactory);
    }

    public EditingGraphMousePlugin(int modifiers, Supplier<N> nodeFactory, Supplier<E> edgeFactory) {
        super(modifiers);
        this.cursor = Cursor.getPredefinedCursor(1);
        this.nodeSupport = new SimpleNodeSupport(nodeFactory);
        this.edgeSupport = new SimpleEdgeSupport(edgeFactory);
    }

    @Override
    public boolean checkModifiers(MouseEvent e) {
        return (e.getModifiers() & this.modifiers) != 0;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.checkModifiers(e)) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            LayoutModel layoutModel = vv.getModel().getLayoutModel();
            Point p = e.getPoint();
            NetworkElementAccessor pickSupport = vv.getPickSupport();
            if (pickSupport != null) {
                Object node = pickSupport.getNode(layoutModel, ((Point2D)p).getX(), ((Point2D)p).getY());
                if (node != null) {
                    this.createMode = Creating.EDGE;
                    this.edgeSupport.startEdgeCreate(vv, node, e.getPoint());
                } else {
                    this.createMode = Creating.NODE;
                    this.nodeSupport.startNodeCreate(vv, e.getPoint());
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.checkModifiers(e)) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            LayoutModel layoutModel = vv.getModel().getLayoutModel();
            Point p = e.getPoint();
            if (this.createMode == Creating.EDGE) {
                NetworkElementAccessor pickSupport = vv.getPickSupport();
                Object node = null;
                if (pickSupport != null) {
                    node = pickSupport.getNode(layoutModel, ((Point2D)p).getX(), ((Point2D)p).getY());
                }
                if (node != null) {
                    this.edgeSupport.endEdgeCreate(vv, node);
                    vv.getEdgeSpatial().recalculate();
                } else {
                    this.edgeSupport.abort(vv);
                }
            } else if (this.createMode == Creating.NODE) {
                this.nodeSupport.endNodeCreate(vv, e.getPoint());
                vv.getNodeSpatial().recalculate();
            }
        }
        this.createMode = Creating.UNDETERMINED;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.checkModifiers(e)) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            if (this.createMode == Creating.EDGE) {
                this.edgeSupport.midEdgeCreate(vv, e.getPoint());
            } else if (this.createMode == Creating.NODE) {
                this.nodeSupport.midNodeCreate(vv, e.getPoint());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public NodeSupport<N, E> getNodeSupport() {
        return this.nodeSupport;
    }

    public void setNodeSupport(NodeSupport<N, E> nodeSupport) {
        this.nodeSupport = nodeSupport;
    }

    public EdgeSupport<N, E> edgesupport() {
        return this.edgeSupport;
    }

    public void setEdgeSupport(EdgeSupport<N, E> edgeSupport) {
        this.edgeSupport = edgeSupport;
    }

    private static enum Creating {
        EDGE,
        NODE,
        UNDETERMINED;

    }
}

