/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractPopupGraphMousePlugin;
import edu.uci.ics.jung.visualization.layout.NetworkElementAccessor;
import edu.uci.ics.jung.visualization.picking.PickedState;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class EditingPopupGraphMousePlugin<N, E>
extends AbstractPopupGraphMousePlugin {
    protected Supplier<N> nodeFactory;
    protected Supplier<E> edgeFactory;

    public EditingPopupGraphMousePlugin(Supplier<N> nodeFactory, Supplier<E> edgeFactory) {
        this.nodeFactory = nodeFactory;
        this.edgeFactory = edgeFactory;
    }

    @Override
    protected void handlePopup(MouseEvent e) {
        final VisualizationViewer vv = (VisualizationViewer)e.getSource();
        LayoutModel layoutModel = vv.getModel().getLayoutModel();
        final MutableNetwork graph = (MutableNetwork)vv.getModel().getNetwork();
        final Point p = e.getPoint();
        NetworkElementAccessor pickSupport = vv.getPickSupport();
        if (pickSupport != null) {
            final Object node = pickSupport.getNode(layoutModel, ((Point2D)p).getX(), ((Point2D)p).getY());
            final Object edge = pickSupport.getEdge(layoutModel, ((Point2D)p).getX(), ((Point2D)p).getY());
            final PickedState pickedNodeState = vv.getPickedNodeState();
            final PickedState pickedEdgeState = vv.getPickedEdgeState();
            JPopupMenu popup = new JPopupMenu();
            if (node != null) {
                Set picked = pickedNodeState.getPicked();
                if (picked.size() > 0) {
                    JMenu menu = new JMenu("Create " + (graph.isDirected() ? "Directed" : "Undirected") + " Edge");
                    popup.add(menu);
                    for (final Object other : picked) {
                        menu.add(new AbstractAction("[" + other + "," + node + "]"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                graph.addEdge(other, node, EditingPopupGraphMousePlugin.this.edgeFactory.get());
                                vv.repaint();
                            }
                        });
                    }
                }
                popup.add(new AbstractAction("Delete Node"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        pickedNodeState.pick(node, false);
                        graph.removeNode(node);
                        vv.getNodeSpatial().recalculate();
                        vv.repaint();
                    }
                });
            } else if (edge != null) {
                popup.add(new AbstractAction("Delete Edge"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        pickedEdgeState.pick(edge, false);
                        graph.removeEdge(edge);
                        vv.getEdgeSpatial().recalculate();
                        vv.repaint();
                    }
                });
            } else {
                popup.add(new AbstractAction("Create Node"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object newNode = EditingPopupGraphMousePlugin.this.nodeFactory.get();
                        graph.addNode(newNode);
                        Point2D p2d = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(p);
                        vv.getModel().getLayoutModel().set(newNode, p2d.getX(), p2d.getY());
                        vv.repaint();
                    }
                });
            }
            if (popup.getComponentCount() > 0) {
                popup.show(vv, e.getX(), e.getY());
            }
        }
    }
}

