/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.Lens;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class LensMagnificationGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseWheelListener {
    protected final float floor;
    protected final float ceiling;
    protected final float delta;

    public LensMagnificationGraphMousePlugin() {
        this(2);
    }

    public LensMagnificationGraphMousePlugin(float floor, float ceiling, float delta) {
        this(2, floor, ceiling, delta);
    }

    public LensMagnificationGraphMousePlugin(int modifiers) {
        this(modifiers, 0.5f, 4.0f, 0.2f);
    }

    public LensMagnificationGraphMousePlugin(int modifiers, float floor, float ceiling, float delta) {
        super(modifiers);
        this.floor = floor;
        this.ceiling = ceiling;
        this.delta = delta;
    }

    @Override
    public boolean checkModifiers(MouseEvent e) {
        return (e.getModifiers() & this.modifiers) != 0;
    }

    private void changeMagnification(Lens lens, float delta) {
        float magnification = lens.getMagnification() + delta;
        magnification = Math.max(this.floor, magnification);
        magnification = Math.min(magnification, this.ceiling);
        lens.setMagnification(magnification);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean accepted = this.checkModifiers(e);
        float delta = this.delta;
        if (accepted) {
            Lens lens;
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            MutableTransformer layoutTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
            MutableTransformer viewTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW);
            int amount = e.getWheelRotation();
            if (amount < 0) {
                delta = -delta;
            }
            Lens lens2 = layoutTransformer instanceof LensTransformer ? ((LensTransformer)layoutTransformer).getLens() : (lens = viewTransformer instanceof LensTransformer ? ((LensTransformer)viewTransformer).getLens() : null);
            if (lens != null) {
                this.changeMagnification(lens, delta);
            }
            vv.repaint();
            e.consume();
        }
    }
}

