/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.TranslatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.Lens;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

public class LensTranslatingGraphMousePlugin
extends TranslatingGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    protected boolean dragOnLens;
    protected boolean dragOnEdge;
    protected double edgeOffset;

    public LensTranslatingGraphMousePlugin() {
        this(16);
    }

    public LensTranslatingGraphMousePlugin(int modifiers) {
        super(modifiers);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
        MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.VIEW);
        MutableTransformer layoutTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        Point2D p = e.getPoint();
        p = viewTransformer instanceof LensTransformer ? ((LensTransformer)viewTransformer).getDelegate().inverseTransform(p) : viewTransformer.inverseTransform(p);
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            Lens lens;
            vv.setCursor(Cursor.getPredefinedCursor(13));
            if (layoutTransformer instanceof LensTransformer) {
                lens = ((LensTransformer)layoutTransformer).getLens();
                this.testViewCenter(lens, p);
            }
            if (viewTransformer instanceof LensTransformer) {
                lens = ((LensTransformer)viewTransformer).getLens();
                this.testViewCenter(lens, p);
            }
            vv.repaint();
        }
        super.mousePressed(e);
    }

    private void setViewCenter(Lens lens, Point2D point) {
        lens.setCenter(point);
    }

    private void setViewRadius(Lens lens, Point2D point) {
        double distanceFromCenter = lens.getDistanceFromCenter(point);
        lens.setRadius(distanceFromCenter + this.edgeOffset);
    }

    private void testViewCenter(Lens lens, Point2D point) {
        double distanceFromCenter = lens.getDistanceFromCenter(point);
        if (distanceFromCenter < 10.0) {
            lens.setCenter(point);
            this.dragOnLens = true;
        } else if (Math.abs(distanceFromCenter - lens.getRadius()) < 10.0) {
            this.edgeOffset = lens.getRadius() - distanceFromCenter;
            lens.setRadius(distanceFromCenter + this.edgeOffset);
            this.dragOnEdge = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.dragOnLens = false;
        this.dragOnEdge = false;
        this.edgeOffset = 0.0;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            Lens lens;
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            MultiLayerTransformer multiLayerTransformer = vv.getRenderContext().getMultiLayerTransformer();
            MutableTransformer layoutTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.LAYOUT);
            MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(MultiLayerTransformer.Layer.VIEW);
            Lens lens2 = layoutTransformer instanceof LensTransformer ? ((LensTransformer)layoutTransformer).getLens() : (lens = viewTransformer instanceof LensTransformer ? ((LensTransformer)viewTransformer).getLens() : null);
            if (lens != null) {
                Point2D p = e.getPoint();
                p = viewTransformer instanceof LensTransformer ? ((LensTransformer)viewTransformer).getDelegate().inverseTransform(p) : viewTransformer.inverseTransform(p);
                vv.setCursor(Cursor.getPredefinedCursor(13));
                if (this.dragOnLens) {
                    this.setViewCenter(lens, p);
                    e.consume();
                    vv.repaint();
                } else if (this.dragOnEdge) {
                    this.setViewRadius(lens, p);
                    e.consume();
                    vv.repaint();
                } else {
                    super.mouseDragged(e);
                }
            }
        }
    }
}

