/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.decorators;

import com.google.common.base.Preconditions;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Network;
import edu.uci.ics.jung.visualization.decorators.ParallelEdgeShapeFunction;
import edu.uci.ics.jung.visualization.util.ArrowFactory;
import edu.uci.ics.jung.visualization.util.Context;
import edu.uci.ics.jung.visualization.util.EdgeIndexFunction;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.function.Function;

public class EdgeShape<E> {
    private static final Line2D LINE = new Line2D.Float(0.0f, 0.0f, 1.0f, 0.0f);
    private static final GeneralPath BENT_LINE = new GeneralPath();
    private static final QuadCurve2D QUAD_CURVE = new QuadCurve2D.Float();
    private static final CubicCurve2D CUBIC_CURVE = new CubicCurve2D.Float();
    private static final Ellipse2D ELLIPSE = new Ellipse2D.Float(-0.5f, -0.5f, 1.0f, 1.0f);
    private static final Rectangle2D BOX = new Rectangle2D.Float();
    private static final GeneralPath BOW_TIE = new GeneralPath(0);
    private static GeneralPath triangle;
    protected static final Loop loop;

    private static <E> boolean isLoop(Network<?, E> graph, E edge) {
        EndpointPair endpoints = graph.incidentNodes(edge);
        Preconditions.checkNotNull((Object)endpoints);
        return endpoints.nodeU().equals(endpoints.nodeV());
    }

    public static <N, E> Line<N, E> line() {
        return new Line();
    }

    public static <E> QuadCurve quadCurve() {
        return new QuadCurve();
    }

    public static <E> CubicCurve cubicCurve() {
        return new CubicCurve();
    }

    public static <E> Orthogonal orthogonal() {
        return new Orthogonal();
    }

    public static <E> Wedge wedge(int width) {
        return new Wedge(width);
    }

    private static <N, E> int getIndex(Context<Network<N, E>, E> context, EdgeIndexFunction<N, E> edgeIndexFunction) {
        return edgeIndexFunction == null ? 1 : edgeIndexFunction.getIndex(context);
    }

    private static Shape buildFrame(RectangularShape shape, int index) {
        float x = -0.5f;
        float y = -0.5f;
        float diam = 1.0f;
        diam += diam * (float)index / 2.0f;
        x += x * (float)index / 2.0f;
        y += y * (float)index / 2.0f;
        shape.setFrame(x, y, diam, diam);
        return shape;
    }

    static {
        loop = new Loop();
    }

    public static class Orthogonal<N, E>
    extends ParallelEdgeShapeFunction<N, E> {
        Box box = new Box();

        @Override
        public Shape apply(Context<Network<N, E>, E> context) {
            Network graph = (Network)context.graph;
            Object e = context.element;
            return EdgeShape.isLoop(graph, e) ? this.box.apply(context) : LINE;
        }
    }

    public static class Box<N, E>
    extends ParallelEdgeShapeFunction<N, E> {
        @Override
        public Shape apply(Context<Network<N, E>, E> context) {
            Network graph = (Network)context.graph;
            Object e = context.element;
            return EdgeShape.buildFrame(BOX, EdgeShape.getIndex(context, this.edgeIndexFunction));
        }
    }

    public static class Wedge<N, E>
    extends ParallelEdgeShapeFunction<N, E> {
        public Wedge(int width) {
            triangle = ArrowFactory.getWedgeArrow(width, 1.0f);
            triangle.transform(AffineTransform.getTranslateInstance(1.0, 0.0));
            BOW_TIE.moveTo(0.0f, width / 2);
            BOW_TIE.lineTo(1.0f, -width / 2);
            BOW_TIE.lineTo(1.0f, width / 2);
            BOW_TIE.lineTo(0.0f, -width / 2);
            BOW_TIE.closePath();
        }

        @Override
        public Shape apply(Context<Network<N, E>, E> context) {
            Network graph = (Network)context.graph;
            Object e = context.element;
            if (EdgeShape.isLoop(graph, e)) {
                return loop.apply(context);
            }
            return graph.isDirected() ? triangle : BOW_TIE;
        }
    }

    public static class Loop<N, E>
    extends ParallelEdgeShapeFunction<N, E> {
        @Override
        public Shape apply(Context<Network<N, E>, E> context) {
            Network graph = (Network)context.graph;
            Object e = context.element;
            return EdgeShape.buildFrame(ELLIPSE, EdgeShape.getIndex(context, this.edgeIndexFunction));
        }
    }

    public static class SimpleLoop<E>
    implements Function<E, Shape> {
        @Override
        public Shape apply(E e) {
            return ELLIPSE;
        }
    }

    public static class CubicCurve<N, E>
    extends ParallelEdgeShapeFunction<N, E> {
        @Override
        public void setEdgeIndexFunction(EdgeIndexFunction<N, E> edgeIndexFunction) {
            this.edgeIndexFunction = edgeIndexFunction;
            loop.setEdgeIndexFunction(edgeIndexFunction);
        }

        @Override
        public Shape apply(Context<Network<N, E>, E> context) {
            Network graph = (Network)context.graph;
            Object e = context.element;
            if (EdgeShape.isLoop(graph, e)) {
                return loop.apply(context);
            }
            int index = EdgeShape.getIndex(context, this.edgeIndexFunction);
            float controlY = this.control_offset_increment + this.control_offset_increment * (float)index;
            CUBIC_CURVE.setCurve(0.0, 0.0, 0.33f, 2.0f * controlY, 0.66f, -controlY, 1.0, 0.0);
            return CUBIC_CURVE;
        }
    }

    public static class QuadCurve<N, E>
    extends ParallelEdgeShapeFunction<N, E> {
        @Override
        public void setEdgeIndexFunction(EdgeIndexFunction<N, E> parallelEdgeIndexFunction) {
            this.edgeIndexFunction = parallelEdgeIndexFunction;
            loop.setEdgeIndexFunction(parallelEdgeIndexFunction);
        }

        @Override
        public Shape apply(Context<Network<N, E>, E> context) {
            Network graph = (Network)context.graph;
            Object e = context.element;
            if (EdgeShape.isLoop(graph, e)) {
                return loop.apply(context);
            }
            int index = EdgeShape.getIndex(context, this.edgeIndexFunction);
            float controlY = this.control_offset_increment + this.control_offset_increment * (float)index;
            QUAD_CURVE.setCurve(0.0, 0.0, 0.5, controlY, 1.0, 0.0);
            return QUAD_CURVE;
        }
    }

    public static class BentLine<N, E>
    extends ParallelEdgeShapeFunction<N, E> {
        @Override
        public void setEdgeIndexFunction(EdgeIndexFunction<N, E> edgeIndexFunction) {
            this.edgeIndexFunction = edgeIndexFunction;
            loop.setEdgeIndexFunction(edgeIndexFunction);
        }

        @Override
        public Shape apply(Context<Network<N, E>, E> context) {
            Network graph = (Network)context.graph;
            Object e = context.element;
            if (EdgeShape.isLoop(graph, e)) {
                return loop.apply(context);
            }
            int index = EdgeShape.getIndex(context, this.edgeIndexFunction);
            float controlY = this.control_offset_increment + this.control_offset_increment * (float)index;
            BENT_LINE.reset();
            BENT_LINE.moveTo(0.0f, 0.0f);
            BENT_LINE.lineTo(0.5f, controlY);
            BENT_LINE.lineTo(1.0f, 1.0f);
            return BENT_LINE;
        }
    }

    public static class Line<N, E>
    extends EdgeShape<E>
    implements Function<Context<Network<N, E>, E>, Shape> {
        @Override
        public Shape apply(Context<Network<N, E>, E> context) {
            Network graph = (Network)context.graph;
            Object e = context.element;
            return EdgeShape.isLoop(graph, e) ? ELLIPSE : LINE;
        }
    }
}

