/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.decorators;

import edu.uci.ics.jung.visualization.util.ImageShapeUtils;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class NodeIconShapeFunction<N>
implements Function<N, Shape> {
    protected Map<Image, Shape> shapeMap = new HashMap<Image, Shape>();
    protected Map<N, Icon> iconMap;
    protected Function<N, Shape> delegate;

    public NodeIconShapeFunction(Function<N, Shape> delegate) {
        this.delegate = delegate;
    }

    public Function<N, Shape> getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Function<N, Shape> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Shape apply(N v) {
        Icon icon = this.iconMap.get(v);
        if (icon != null && icon instanceof ImageIcon) {
            Image image = ((ImageIcon)icon).getImage();
            Shape shape = this.shapeMap.get(image);
            if (shape == null && (shape = ImageShapeUtils.getShape(image, 30)).getBounds().getWidth() > 0.0 && shape.getBounds().getHeight() > 0.0) {
                int width = image.getWidth(null);
                int height = image.getHeight(null);
                AffineTransform transform = AffineTransform.getTranslateInstance(-width / 2, -height / 2);
                shape = transform.createTransformedShape(shape);
                this.shapeMap.put(image, shape);
            }
            return shape;
        }
        return this.delegate.apply(v);
    }

    public Map<N, Icon> getIconMap() {
        return this.iconMap;
    }

    public void setIconMap(Map<N, Icon> iconMap) {
        this.iconMap = iconMap;
    }

    public Map<Image, Shape> getShapeMap() {
        return this.shapeMap;
    }

    public void setShapeMap(Map<Image, Shape> shapeMap) {
        this.shapeMap = shapeMap;
    }
}

