/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.layout;

import com.google.common.collect.Maps;
import com.google.common.graph.Graph;
import edu.uci.ics.jung.layout.algorithms.LayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import java.awt.geom.AffineTransform;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateLayoutModel<N>
implements LayoutModel<N> {
    private static final Logger log = LoggerFactory.getLogger(AggregateLayoutModel.class);
    protected final LayoutModel<N> delegate;
    protected Map<LayoutModel<N>, Point> layouts = Maps.newHashMap();

    public AggregateLayoutModel(LayoutModel<N> delegate) {
        this.delegate = delegate;
    }

    public void put(LayoutModel<N> layoutModel, Point center) {
        if (log.isTraceEnabled()) {
            log.trace("put layout: {} at {}", layoutModel, (Object)center);
        }
        this.layouts.put(layoutModel, center);
        this.connectListeners(layoutModel);
    }

    private void connectListeners(LayoutModel<N> newLayoutModel) {
        for (LayoutModel.LayoutStateChangeListener layoutStateChangeListener : this.delegate.getLayoutStateChangeSupport().getLayoutStateChangeListeners()) {
            newLayoutModel.getLayoutStateChangeSupport().addLayoutStateChangeListener(layoutStateChangeListener);
        }
        for (LayoutModel.ChangeListener changeListener : this.delegate.getChangeSupport().getChangeListeners()) {
            newLayoutModel.getChangeSupport().addChangeListener(changeListener);
        }
    }

    private void disconnectListeners(LayoutModel<N> newLayoutModel) {
        newLayoutModel.getLayoutStateChangeSupport().getLayoutStateChangeListeners().clear();
        newLayoutModel.getChangeSupport().getChangeListeners().clear();
    }

    public Point get(LayoutModel<N> layout) {
        return this.layouts.get(layout);
    }

    public void accept(LayoutAlgorithm<N> layoutAlgorithm) {
        this.delegate.accept(layoutAlgorithm);
    }

    public Map<N, Point> getLocations() {
        return this.delegate.getLocations();
    }

    public void setSize(int width, int height) {
        this.delegate.setSize(width, height);
    }

    public void stopRelaxer() {
        this.delegate.stopRelaxer();
        for (LayoutModel<N> childLayoutModel : this.layouts.keySet()) {
            childLayoutModel.stopRelaxer();
        }
    }

    public void setRelaxing(boolean relaxing) {
        this.delegate.setRelaxing(relaxing);
    }

    public boolean isRelaxing() {
        return this.delegate.isRelaxing();
    }

    public CompletableFuture getTheFuture() {
        return this.delegate.getTheFuture();
    }

    public void set(N node, Point location) {
        this.delegate.set(node, location);
    }

    public void set(N node, double x, double y) {
        this.delegate.set(node, x, y);
    }

    public Point get(N node) {
        return this.delegate.get(node);
    }

    public Graph<N> getGraph() {
        return this.delegate.getGraph();
    }

    public void setGraph(Graph<N> graph) {
        this.delegate.setGraph(graph);
    }

    public void remove(LayoutModel<N> layout) {
        this.layouts.remove(layout);
    }

    public void removeAll() {
        this.layouts.clear();
    }

    public int getWidth() {
        return this.delegate.getWidth();
    }

    public int getHeight() {
        return this.delegate.getHeight();
    }

    public boolean isLocked(N node) {
        for (LayoutModel<N> layoutModel : this.layouts.keySet()) {
            if (!layoutModel.isLocked(node)) continue;
            return true;
        }
        return this.delegate.isLocked(node);
    }

    public void lock(N node, boolean state) {
        for (LayoutModel<N> layoutModel : this.layouts.keySet()) {
            if (!layoutModel.getGraph().nodes().contains(node)) continue;
            layoutModel.lock(node, state);
        }
        this.delegate.lock(node, state);
    }

    public void lock(boolean locked) {
        this.delegate.lock(locked);
        for (LayoutModel<N> model : this.layouts.keySet()) {
            model.lock(locked);
        }
    }

    public boolean isLocked() {
        return this.delegate.isLocked();
    }

    public void setInitializer(Function<N, Point> initializer) {
        this.delegate.setInitializer(initializer);
    }

    public LayoutModel.LayoutStateChangeSupport getLayoutStateChangeSupport() {
        return this.delegate.getLayoutStateChangeSupport();
    }

    public LayoutModel.ChangeSupport getChangeSupport() {
        return this.delegate.getChangeSupport();
    }

    public Point apply(N node) {
        for (LayoutModel<N> layoutModel : this.layouts.keySet()) {
            if (!layoutModel.getGraph().nodes().contains(node)) continue;
            Point center = this.layouts.get(layoutModel);
            int width = layoutModel.getWidth();
            int height = layoutModel.getHeight();
            AffineTransform at = AffineTransform.getTranslateInstance(center.x - (double)(width / 2), center.y - (double)(height / 2));
            Point nodeCenter = (Point)layoutModel.apply(node);
            log.trace("sublayout center is {}", (Object)nodeCenter);
            double[] srcPoints = new double[]{nodeCenter.x, nodeCenter.y};
            double[] destPoints = new double[2];
            at.transform(srcPoints, 0, destPoints, 0, 1);
            return Point.of((double)destPoints[0], (double)destPoints[1]);
        }
        return (Point)this.delegate.apply(node);
    }
}

