/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.layout;

import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.layout.algorithms.AbstractIterativeLayoutAlgorithm;
import edu.uci.ics.jung.layout.algorithms.LayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.LoadingCacheLayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.visualization.VisualizationServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimationLayoutAlgorithm<N>
extends AbstractIterativeLayoutAlgorithm<N>
implements IterativeContext {
    private static final Logger log = LoggerFactory.getLogger(AnimationLayoutAlgorithm.class);
    protected boolean done = false;
    protected int count = 20;
    protected int counter = 0;
    LayoutModel<N> transitionLayoutModel;
    VisualizationServer<N, ?> visualizationServer;
    LayoutAlgorithm<N> endLayoutAlgorithm;
    LayoutModel<N> layoutModel;

    public AnimationLayoutAlgorithm(VisualizationServer<N, ?> visualizationServer, LayoutAlgorithm<N> endLayoutAlgorithm) {
        this.visualizationServer = visualizationServer;
        this.endLayoutAlgorithm = endLayoutAlgorithm;
        this.shouldPreRelax = false;
    }

    public void visit(LayoutModel<N> layoutModel) {
        this.layoutModel = layoutModel;
        this.transitionLayoutModel = LoadingCacheLayoutModel.builder().setGraph(this.visualizationServer.getModel().getNetwork().asGraph()).setLayoutModel(layoutModel).setInitializer(layoutModel).build();
        this.transitionLayoutModel.accept(this.endLayoutAlgorithm);
    }

    public void step() {
        for (Object v : this.layoutModel.getGraph().nodes()) {
            Point tp = (Point)this.layoutModel.apply(v);
            Point fp = (Point)this.transitionLayoutModel.apply(v);
            double dx = (fp.x - tp.x) / (double)(this.count - this.counter);
            double dy = (fp.y - tp.y) / (double)(this.count - this.counter);
            log.trace("dx:{},dy:{}", (Object)dx, (Object)dy);
            this.layoutModel.set(v, tp.x + dx, tp.y + dy);
        }
        ++this.counter;
        if (this.counter >= this.count) {
            this.done = true;
            this.transitionLayoutModel.stopRelaxer();
            this.visualizationServer.getModel().setLayoutAlgorithm(this.endLayoutAlgorithm);
        }
    }

    public boolean done() {
        return this.done;
    }
}

