/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Network;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ParallelEdgeShapeFunction;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeArrowRenderingSupport;
import edu.uci.ics.jung.visualization.renderers.EdgeArrowRenderingSupport;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.util.Context;
import edu.uci.ics.jung.visualization.util.EdgeIndexFunction;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.function.Predicate;

public class BasicEdgeRenderer<N, E>
implements Renderer.Edge<N, E> {
    protected EdgeArrowRenderingSupport<N, E> edgeArrowRenderingSupport = new BasicEdgeArrowRenderingSupport();

    @Override
    public void paintEdge(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, E e) {
        GraphicsDecorator g2d = renderContext.getGraphicsContext();
        if (!renderContext.getEdgeIncludePredicate().test(e)) {
            return;
        }
        EndpointPair endpoints = visualizationModel.getNetwork().incidentNodes(e);
        Object u = endpoints.nodeU();
        Object v = endpoints.nodeV();
        Predicate<N> nodeIncludePredicate = renderContext.getNodeIncludePredicate();
        if (!nodeIncludePredicate.test(u) || !nodeIncludePredicate.test(v)) {
            return;
        }
        Stroke new_stroke = renderContext.edgeStrokeFunction().apply(e);
        Stroke old_stroke = g2d.getStroke();
        if (new_stroke != null) {
            g2d.setStroke(new_stroke);
        }
        this.drawSimpleEdge(renderContext, visualizationModel, e);
        if (new_stroke != null) {
            g2d.setStroke(old_stroke);
        }
    }

    protected Shape prepareFinalEdgeShape(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, E e, int[] coords, boolean[] loop) {
        EndpointPair endpoints = visualizationModel.getNetwork().incidentNodes(e);
        Object v1 = endpoints.nodeU();
        Object v2 = endpoints.nodeV();
        Point p1 = (Point)visualizationModel.getLayoutModel().apply(v1);
        Point p2 = (Point)visualizationModel.getLayoutModel().apply(v2);
        Point2D p2d1 = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, new Point2D.Double(p1.x, p1.y));
        Point2D p2d2 = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, new Point2D.Double(p2.x, p2.y));
        float x1 = (float)p2d1.getX();
        float y1 = (float)p2d1.getY();
        float x2 = (float)p2d2.getX();
        float y2 = (float)p2d2.getY();
        coords[0] = (int)x1;
        coords[1] = (int)y1;
        coords[2] = (int)x2;
        coords[3] = (int)y2;
        boolean isLoop = loop[0] = v1.equals(v2);
        Shape s2 = renderContext.getNodeShapeFunction().apply(v2);
        Shape edgeShape = renderContext.getEdgeShapeFunction().apply(Context.getInstance(visualizationModel.getNetwork(), e));
        AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
        if (isLoop) {
            Rectangle2D s2Bounds = s2.getBounds2D();
            xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
            xform.translate(0.0, -edgeShape.getBounds2D().getWidth() / 2.0);
        } else if (renderContext.getEdgeShapeFunction() instanceof EdgeShape.Orthogonal) {
            float dx = x2 - x1;
            float dy = y2 - y1;
            int index = 0;
            if (renderContext.getEdgeShapeFunction() instanceof ParallelEdgeShapeFunction) {
                EdgeIndexFunction<N, E> peif = ((ParallelEdgeShapeFunction)renderContext.getEdgeShapeFunction()).getEdgeIndexFunction();
                index = peif.getIndex(Context.getInstance(visualizationModel.getNetwork(), e));
                index *= 20;
            }
            GeneralPath gp = new GeneralPath();
            gp.moveTo(0.0f, 0.0f);
            if (x1 > x2) {
                if (y1 > y2) {
                    gp.lineTo(0.0f, index);
                    gp.lineTo(dx - (float)index, index);
                    gp.lineTo(dx - (float)index, dy);
                    gp.lineTo(dx, dy);
                } else {
                    gp.lineTo(0.0f, -index);
                    gp.lineTo(dx - (float)index, -index);
                    gp.lineTo(dx - (float)index, dy);
                    gp.lineTo(dx, dy);
                }
            } else if (y1 > y2) {
                gp.lineTo(0.0f, index);
                gp.lineTo(dx + (float)index, index);
                gp.lineTo(dx + (float)index, dy);
                gp.lineTo(dx, dy);
            } else {
                gp.lineTo(0.0f, -index);
                gp.lineTo(dx + (float)index, -index);
                gp.lineTo(dx + (float)index, dy);
                gp.lineTo(dx, dy);
            }
            edgeShape = gp;
        } else {
            float dx = x2 - x1;
            float dy = y2 - y1;
            float thetaRadians = (float)Math.atan2(dy, dx);
            xform.rotate(thetaRadians);
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            xform.scale(dist, 1.0);
        }
        edgeShape = xform.createTransformedShape(edgeShape);
        return edgeShape;
    }

    protected void drawSimpleEdge(RenderContext<N, E> renderContext, VisualizationModel<N, E> visualizationModel, E e) {
        Paint draw_paint;
        int[] coords = new int[4];
        boolean[] loop = new boolean[1];
        Shape edgeShape = this.prepareFinalEdgeShape(renderContext, visualizationModel, e, coords, loop);
        int x1 = coords[0];
        int y1 = coords[1];
        int x2 = coords[2];
        int y2 = coords[3];
        boolean isLoop = loop[0];
        GraphicsDecorator g = renderContext.getGraphicsContext();
        Network<N, E> network = visualizationModel.getNetwork();
        Paint oldPaint = g.getPaint();
        Paint fill_paint = renderContext.getEdgeFillPaintFunction().apply(e);
        if (fill_paint != null) {
            g.setPaint(fill_paint);
            g.fill(edgeShape);
        }
        if ((draw_paint = renderContext.getEdgeDrawPaintFunction().apply(e)) != null) {
            g.setPaint(draw_paint);
            g.draw(edgeShape);
        }
        float scalex = (float)g.getTransform().getScaleX();
        float scaley = (float)g.getTransform().getScaleY();
        if ((double)scalex < 0.3 || (double)scaley < 0.3) {
            return;
        }
        if (renderContext.renderEdgeArrow()) {
            Stroke new_stroke = renderContext.getEdgeArrowStrokeFunction().apply(e);
            Stroke old_stroke = g.getStroke();
            if (new_stroke != null) {
                g.setStroke(new_stroke);
            }
            Shape destNodeShape = renderContext.getNodeShapeFunction().apply(network.incidentNodes(e).nodeV());
            AffineTransform xf = AffineTransform.getTranslateInstance(x2, y2);
            destNodeShape = xf.createTransformedShape(destNodeShape);
            AffineTransform at = this.edgeArrowRenderingSupport.getArrowTransform(renderContext, edgeShape, destNodeShape);
            if (at == null) {
                return;
            }
            Shape arrow = renderContext.getEdgeArrow();
            arrow = at.createTransformedShape(arrow);
            g.setPaint(renderContext.getArrowFillPaintFunction().apply(e));
            g.fill(arrow);
            g.setPaint(renderContext.getArrowDrawPaintFunction().apply(e));
            g.draw(arrow);
            if (!network.isDirected()) {
                Shape nodeShape = renderContext.getNodeShapeFunction().apply(network.incidentNodes(e).nodeU());
                xf = AffineTransform.getTranslateInstance(x1, y1);
                nodeShape = xf.createTransformedShape(nodeShape);
                at = this.edgeArrowRenderingSupport.getReverseArrowTransform(renderContext, edgeShape, nodeShape, !isLoop);
                if (at == null) {
                    return;
                }
                arrow = renderContext.getEdgeArrow();
                arrow = at.createTransformedShape(arrow);
                g.setPaint(renderContext.getArrowFillPaintFunction().apply(e));
                g.fill(arrow);
                g.setPaint(renderContext.getArrowDrawPaintFunction().apply(e));
                g.draw(arrow);
            }
            if (new_stroke != null) {
                g.setStroke(old_stroke);
            }
        }
        g.setPaint(oldPaint);
    }

    @Override
    public EdgeArrowRenderingSupport<N, E> getEdgeArrowRenderingSupport() {
        return this.edgeArrowRenderingSupport;
    }

    @Override
    public void setEdgeArrowRenderingSupport(EdgeArrowRenderingSupport<N, E> edgeArrowRenderingSupport) {
        this.edgeArrowRenderingSupport = edgeArrowRenderingSupport;
    }
}

