/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.spatial;

import com.google.common.collect.EvictingQueue;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.util.RadiusNetworkNodeAccessor;
import edu.uci.ics.jung.visualization.spatial.Spatial;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpatial<T, NT>
implements Spatial<T> {
    private static Logger log = LoggerFactory.getLogger(AbstractSpatial.class);
    boolean active = false;
    protected Rectangle2D rectangle;
    protected Collection<Shape> pickShapes = EvictingQueue.create((int)4);
    protected List<Shape> gridCache;
    protected LayoutModel<NT> layoutModel;
    RadiusNetworkNodeAccessor<NT> fallback;

    protected AbstractSpatial(LayoutModel<NT> layoutModel) {
        this.layoutModel = layoutModel;
        if (layoutModel != null) {
            this.rectangle = new Rectangle2D.Double(0.0, 0.0, layoutModel.getWidth(), layoutModel.getHeight());
            this.fallback = new RadiusNetworkNodeAccessor();
        }
    }

    @Override
    public Collection<Shape> getPickShapes() {
        return this.pickShapes;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.gridCache = null;
        this.active = active;
    }

    protected NT getClosest(Collection<NT> nodes, double x, double y, double radius) {
        double radiusSq = radius * radius;
        if (nodes.size() > 0) {
            double closestSoFar = Double.MAX_VALUE;
            NT winner = null;
            double winningDistance = -1.0;
            for (NT node : nodes) {
                Point loc = (Point)this.layoutModel.apply(node);
                double dist = loc.distanceSquared(x, y);
                if (!(dist < radiusSq) || !(dist < closestSoFar)) continue;
                closestSoFar = dist;
                winner = node;
                winningDistance = dist;
            }
            if (log.isTraceEnabled()) {
                log.trace("closest winner is {} at distance {}", winner, (Object)winningDistance);
            }
            return winner;
        }
        return null;
    }

    public void layoutStateChanged(LayoutModel.LayoutStateChangeEvent evt) {
        log.trace("layoutStateChanged:{}", (Object)evt);
        this.setActive(!evt.active);
        if (!evt.active) {
            log.trace("will recalcluate");
            this.recalculate();
            if (this.layoutModel instanceof LayoutModel.ChangeSupport) {
                ((LayoutModel.ChangeSupport)this.layoutModel).fireChanged();
            }
        }
    }
}

