/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import com.google.common.base.Preconditions;
import java.awt.Dimension;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lens {
    private static final Logger log = LoggerFactory.getLogger(Lens.class);
    protected RectangularShape lensShape = new Ellipse2D.Float();
    protected float magnification = 0.7f;

    public Lens(Dimension d) {
        this.setSize(d);
    }

    public void setSize(Dimension d) {
        Preconditions.checkNotNull((Object)d);
        Preconditions.checkArgument((d.width > 0 ? 1 : 0) != 0, (Object)"width must be > 0");
        Preconditions.checkArgument((d.height > 0 ? 1 : 0) != 0, (Object)"height must be > 0");
        float width = (float)d.width / 1.5f;
        float height = (float)d.height / 1.5f;
        this.lensShape.setFrame(((float)d.width - width) / 2.0f, ((float)d.height - height) / 2.0f, width, height);
    }

    public float getMagnification() {
        return this.magnification;
    }

    public void setMagnification(float magnification) {
        log.trace("setmagnification to {}", (Object)Float.valueOf(magnification));
        this.magnification = magnification;
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.lensShape.getCenterX(), this.lensShape.getCenterY());
    }

    public void setCenter(Point2D viewCenter) {
        double width = this.lensShape.getWidth();
        double height = this.lensShape.getHeight();
        this.lensShape.setFrame(viewCenter.getX() - width / 2.0, viewCenter.getY() - height / 2.0, width, height);
    }

    public double getRadius() {
        return this.lensShape.getHeight() / 2.0;
    }

    public void setRadius(double viewRadius) {
        double x = this.lensShape.getCenterX();
        double y = this.lensShape.getCenterY();
        double viewRatio = this.getRatio();
        this.lensShape.setFrame(x - viewRadius / viewRatio, y - viewRadius, 2.0 * viewRadius / viewRatio, 2.0 * viewRadius);
    }

    public double getRatio() {
        return this.lensShape.getHeight() / this.lensShape.getWidth();
    }

    public void setLensShape(RectangularShape ellipse) {
        this.lensShape = ellipse;
    }

    public RectangularShape getLensShape() {
        return this.lensShape;
    }

    public double getDistanceFromCenter(Point2D p) {
        double dx = this.lensShape.getCenterX() - p.getX();
        double dy = this.lensShape.getCenterY() - p.getY();
        return Math.sqrt((dx *= this.getRatio()) * dx + dy * dy);
    }
}

