/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform.shape;

import edu.uci.ics.jung.visualization.transform.BidirectionalTransformer;
import edu.uci.ics.jung.visualization.transform.shape.MagnifyShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.TransformingFlatnessGraphics;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.Icon;

public class MagnifyIconGraphics
extends TransformingFlatnessGraphics {
    public MagnifyIconGraphics(BidirectionalTransformer transformer) {
        this(transformer, null);
    }

    public MagnifyIconGraphics(BidirectionalTransformer Function2, Graphics2D delegate) {
        super(Function2, delegate);
    }

    @Override
    public void draw(Icon icon, Component c, Shape clip, int x, int y) {
        if (this.transformer instanceof MagnifyShapeTransformer) {
            MagnifyShapeTransformer mst = (MagnifyShapeTransformer)this.transformer;
            int w = icon.getIconWidth();
            int h = icon.getIconHeight();
            Rectangle2D.Double r = new Rectangle2D.Double(x - w / 2, y - h / 2, w, h);
            RectangularShape lens = mst.getLens().getLensShape();
            if (lens.intersects(r)) {
                Rectangle2D s = mst.magnify(r).getBounds2D();
                if (lens.intersects(s)) {
                    clip = mst.transform(clip);
                    double sx = s.getWidth() / ((RectangularShape)r).getWidth();
                    double sy = s.getHeight() / ((RectangularShape)r).getHeight();
                    AffineTransform old = this.delegate.getTransform();
                    AffineTransform xform = new AffineTransform(old);
                    xform.translate(s.getMinX(), s.getMinY());
                    xform.scale(sx, sy);
                    xform.translate(-s.getMinX(), -s.getMinY());
                    Shape oldClip = this.delegate.getClip();
                    this.delegate.clip(clip);
                    this.delegate.setTransform(xform);
                    icon.paintIcon(c, this.delegate, (int)s.getMinX(), (int)s.getMinY());
                    this.delegate.setTransform(old);
                    this.delegate.setClip(oldClip);
                } else {
                    Shape oldClip = this.delegate.getClip();
                    Area viewBounds = new Area(oldClip);
                    viewBounds.subtract(new Area(lens));
                    this.delegate.setClip(viewBounds);
                    icon.paintIcon(c, this.delegate, (int)r.getMinX(), (int)r.getMinY());
                    this.delegate.setClip(oldClip);
                }
            } else {
                icon.paintIcon(c, this.delegate, (int)r.getMinX(), (int)r.getMinY());
            }
        }
    }
}

