/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.blockmodel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import edu.uci.ics.jung.algorithms.blockmodel.NodePartition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Function;

public class StructurallyEquivalent<N>
implements Function<Graph<N>, NodePartition<N>> {
    @Override
    public NodePartition<N> apply(Graph<N> g) {
        ImmutableSet<ImmutableList<N>> nodePairs = this.getEquivalentPairs(g);
        HashSet rv = new HashSet();
        HashMap intermediate = new HashMap();
        for (ImmutableList pair : nodePairs) {
            Set<Object> res = (HashSet<Object>)intermediate.get(pair.get(0));
            if (res == null) {
                res = (Set)intermediate.get(pair.get(1));
            }
            if (res == null) {
                res = new HashSet<Object>();
            }
            res.add(pair.get(0));
            res.add(pair.get(1));
            intermediate.put(pair.get(0), res);
            intermediate.put(pair.get(1), res);
        }
        rv.addAll(intermediate.values());
        ArrayList singletons = new ArrayList(g.nodes());
        singletons.removeAll(intermediate.keySet());
        for (Object v : singletons) {
            Set vSet = Collections.singleton(v);
            intermediate.put(v, vSet);
            rv.add(vSet);
        }
        return new NodePartition<N>(g, intermediate, rv);
    }

    protected ImmutableSet<ImmutableList<N>> getEquivalentPairs(Graph<N> g) {
        ImmutableSet.Builder rv = ImmutableSet.builder();
        HashSet alreadyEquivalent = new HashSet();
        ArrayList l = new ArrayList(g.nodes());
        for (Object v1 : l) {
            if (alreadyEquivalent.contains(v1)) continue;
            ListIterator iterator = l.listIterator(l.indexOf(v1) + 1);
            while (iterator.hasNext()) {
                Object v2 = iterator.next();
                if (alreadyEquivalent.contains(v2) || !this.canBeEquivalent(v1, v2) || !this.isStructurallyEquivalent(g, v1, v2)) continue;
                ImmutableList pair = ImmutableList.of(v1, v2);
                alreadyEquivalent.add(v2);
                rv.add((Object)pair);
            }
        }
        return rv.build();
    }

    protected boolean isStructurallyEquivalent(Graph<N> g, N v1, N v2) {
        boolean b;
        if (g.degree(v1) != g.degree(v2)) {
            return false;
        }
        HashSet n1 = new HashSet(g.predecessors(v1));
        n1.remove(v2);
        n1.remove(v1);
        HashSet n2 = new HashSet(g.predecessors(v2));
        n2.remove(v1);
        n2.remove(v2);
        HashSet o1 = new HashSet(g.successors(v1));
        HashSet o2 = new HashSet(g.successors(v2));
        o1.remove(v1);
        o1.remove(v2);
        o2.remove(v1);
        o2.remove(v2);
        boolean bl = b = n1.equals(n2) && o1.equals(o2);
        if (!b) {
            return b;
        }
        b &= g.successors(v1).contains(v2) == g.successors(v2).contains(v1);
        return b &= g.successors(v1).contains(v1) == g.successors(v2).contains(v2);
    }

    protected boolean canBeEquivalent(N v1, N v2) {
        return true;
    }
}

