/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class BicomponentClusterer<N, E>
implements Function<Graph<N>, Set<Set<N>>> {
    protected Map<N, Number> dfs_num;
    protected Map<N, Number> high;
    protected Map<N, N> parents;
    protected Deque<EndpointPair<N>> stack;
    protected int converse_depth;

    @Override
    public Set<Set<N>> apply(Graph<N> graph) {
        LinkedHashSet<Set<N>> bicomponents = new LinkedHashSet<Set<N>>();
        if (graph.nodes().isEmpty()) {
            return bicomponents;
        }
        this.dfs_num = new HashMap<N, Number>();
        for (Object v : graph.nodes()) {
            this.dfs_num.put(v, 0);
        }
        for (Object v : graph.nodes()) {
            if (this.dfs_num.get(v).intValue() != 0) continue;
            this.high = new HashMap<N, Number>();
            this.stack = new ArrayDeque<EndpointPair<N>>();
            this.parents = new HashMap<N, N>();
            this.converse_depth = graph.nodes().size();
            this.findBiconnectedComponents(graph, v, bicomponents);
            if (graph.nodes().size() - this.converse_depth != 1) continue;
            HashSet s = new HashSet();
            s.add(v);
            bicomponents.add(s);
        }
        return bicomponents;
    }

    protected void findBiconnectedComponents(Graph<N> g, N v, Set<Set<N>> bicomponents) {
        int v_dfs_num = this.converse_depth--;
        this.dfs_num.put(v, v_dfs_num);
        this.high.put(v, v_dfs_num);
        for (Object w : g.adjacentNodes(v)) {
            int w_dfs_num = this.dfs_num.get(w).intValue();
            EndpointPair vw = EndpointPair.unordered(v, w);
            if (w_dfs_num == 0) {
                this.parents.put(w, v);
                this.stack.push(vw);
                this.findBiconnectedComponents(g, w, bicomponents);
                int w_high = this.high.get(w).intValue();
                if (w_high <= v_dfs_num) {
                    EndpointPair<N> endpoints;
                    HashSet<Object> bicomponent = new HashSet<Object>();
                    do {
                        endpoints = this.stack.pop();
                        bicomponent.add(endpoints.nodeU());
                        bicomponent.add(endpoints.nodeV());
                    } while (!endpoints.equals((Object)vw));
                    bicomponents.add(bicomponent);
                }
                this.high.put(v, Math.max(w_high, this.high.get(v).intValue()));
                continue;
            }
            if (w == this.parents.get(v)) continue;
            this.high.put(v, Math.max(w_dfs_num, this.high.get(v).intValue()));
        }
    }
}

