/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import com.google.common.base.Preconditions;
import com.google.common.graph.Graph;
import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.algorithms.util.WeightedChoice;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;

public class KleinbergSmallWorld<N, E> {
    private final double clusteringExponent;
    private final Random random;
    private final int connectionCount;

    private KleinbergSmallWorld(Builder<N, E> builder) {
        this.clusteringExponent = ((Builder)builder).exponent;
        this.random = ((Builder)builder).random;
        this.connectionCount = ((Builder)builder).numConnections;
    }

    public static <N, E> Builder<N, E> builder() {
        return new Builder();
    }

    public void addSmallWorldConnections(MutableNetwork<N, E> graph, Distance<N> distance, Supplier<E> edgeFactory) {
        Preconditions.checkArgument((graph.nodes().size() - 5 >= this.connectionCount ? 1 : 0) != 0);
        for (Object node : graph.nodes()) {
            WeightedChoice weightedChoice = this.getWeightedChoiceForDistance(node, graph.asGraph(), distance);
            HashSet targets = new HashSet();
            while (targets.size() < this.connectionCount) {
                targets.add(weightedChoice.nextItem());
            }
            for (Object target : targets) {
                graph.addEdge(node, target, edgeFactory.get());
            }
        }
    }

    private WeightedChoice<N> getWeightedChoiceForDistance(N source, Graph<N> graph, Distance<N> distance) {
        HashMap nodeWeights = new HashMap();
        Set successors = graph.successors(source);
        for (Object node : graph.nodes()) {
            if (node.equals(source) || successors.contains(node)) continue;
            nodeWeights.put(node, Math.pow(distance.getDistance(source, node).doubleValue(), -this.clusteringExponent));
        }
        Preconditions.checkState((nodeWeights.size() >= this.connectionCount ? 1 : 0) != 0, (String)"number of possible targets (%s) must be greater than connection count (%s)", (int)nodeWeights.size(), (int)this.connectionCount);
        WeightedChoice weightedChoice = new WeightedChoice(nodeWeights, this.random);
        return weightedChoice;
    }

    public static class Builder<N, E> {
        private double exponent = 2.0;
        private int numConnections = 1;
        private Optional<Long> seed = Optional.empty();
        private Random random = new Random(0L);

        private Builder() {
        }

        public Builder<N, E> clusteringExponent(double exponent) {
            this.exponent = exponent;
            return this;
        }

        public Builder<N, E> randomSeed(long seed) {
            this.random.setSeed(seed);
            return this;
        }

        public Builder<N, E> random(Random random) {
            this.random = (Random)Preconditions.checkNotNull((Object)random);
            if (!this.seed.isPresent()) {
                this.seed = Optional.of(0L);
            }
            this.random.setSeed(this.seed.get());
            return this;
        }

        public Builder<N, E> connectionCount(int count) {
            this.numConnections = count;
            return this;
        }

        public KleinbergSmallWorld<N, E> build() {
            return new KleinbergSmallWorld(this);
        }
    }
}

