/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.metrics;

import com.google.common.graph.Graph;
import java.util.function.BiFunction;

public class StructuralHoles<N> {
    protected BiFunction<N, N, ? extends Number> edge_weight;
    protected Graph<N> g;

    public StructuralHoles(Graph<N> graph, BiFunction<N, N, ? extends Number> nev) {
        this.g = graph;
        this.edge_weight = nev;
    }

    public double effectiveSize(N v) {
        double result = this.g.degree(v);
        for (Object u : this.g.adjacentNodes(v)) {
            for (Object w : this.g.adjacentNodes(u)) {
                if (w == v || w == u) continue;
                result -= this.normalizedMutualEdgeWeight(v, w) * this.maxScaledMutualEdgeWeight(u, w);
            }
        }
        return result;
    }

    public double efficiency(N v) {
        double degree = this.g.degree(v);
        if (degree == 0.0) {
            return 0.0;
        }
        return this.effectiveSize(v) / degree;
    }

    public double constraint(N v) {
        double result = 0.0;
        for (Object w : this.g.successors(v)) {
            if (v == w || !this.g.predecessors(v).contains(w)) continue;
            result += this.localConstraint(v, w);
        }
        return result;
    }

    public double hierarchy(N v) {
        double v_degree = this.g.degree(v);
        if (v_degree == 0.0) {
            return Double.NaN;
        }
        if (v_degree == 1.0) {
            return 1.0;
        }
        double v_constraint = this.aggregateConstraint(v);
        double numerator = 0.0;
        for (Object w : this.g.adjacentNodes(v)) {
            if (v == w) continue;
            double sl_constraint = this.localConstraint(v, w) / (v_constraint / v_degree);
            numerator += sl_constraint * Math.log(sl_constraint);
        }
        return numerator / (v_degree * Math.log(v_degree));
    }

    public double localConstraint(N v1, N v2) {
        double nmew_vw = this.normalizedMutualEdgeWeight(v1, v2);
        double inner_result = 0.0;
        for (Object w : this.g.adjacentNodes(v1)) {
            inner_result += this.normalizedMutualEdgeWeight(v1, w) * this.normalizedMutualEdgeWeight(w, v2);
        }
        return (nmew_vw + inner_result) * (nmew_vw + inner_result);
    }

    public double aggregateConstraint(N v) {
        double result = 0.0;
        for (Object w : this.g.adjacentNodes(v)) {
            result += this.localConstraint(v, w) * this.organizationalMeasure(this.g, w);
        }
        return result;
    }

    protected double organizationalMeasure(Graph<N> g, N v) {
        return 1.0;
    }

    protected double normalizedMutualEdgeWeight(N v1, N v2) {
        if (v1 == v2) {
            return 0.0;
        }
        double numerator = this.mutualWeight(v1, v2);
        if (numerator == 0.0) {
            return 0.0;
        }
        double denominator = 0.0;
        for (Object v : this.g.adjacentNodes(v1)) {
            denominator += this.mutualWeight(v1, v);
        }
        if (denominator == 0.0) {
            return 0.0;
        }
        return numerator / denominator;
    }

    protected double mutualWeight(N v1, N v2) {
        double weight = 0.0;
        if (this.g.isDirected()) {
            if (this.g.successors(v1).contains(v2)) {
                weight += this.edge_weight.apply(v1, v2).doubleValue();
            }
            if (this.g.successors(v2).contains(v1)) {
                weight += this.edge_weight.apply(v2, v1).doubleValue();
            }
        } else if (this.g.adjacentNodes(v1).contains(v2)) {
            weight += this.edge_weight.apply(v1, v2).doubleValue();
        }
        return weight;
    }

    protected double maxScaledMutualEdgeWeight(N v1, N v2) {
        if (v1 == v2) {
            return 0.0;
        }
        double numerator = this.mutualWeight(v1, v2);
        if (numerator == 0.0) {
            return 0.0;
        }
        double denominator = 0.0;
        for (Object w : this.g.adjacentNodes(v1)) {
            if (v2 == w) continue;
            denominator = Math.max(numerator, this.mutualWeight(v1, w));
        }
        if (denominator == 0.0) {
            return 0.0;
        }
        return numerator / denominator;
    }
}

