/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.base.Preconditions;
import com.google.common.graph.Network;
import edu.uci.ics.jung.algorithms.scoring.AbstractIterativeScorerWithPriors;
import edu.uci.ics.jung.algorithms.scoring.HITS;
import java.util.function.Function;

public class HITSWithPriors<N, E>
extends AbstractIterativeScorerWithPriors<N, E, HITS.Scores> {
    protected HITS.Scores disappearing_potential = new HITS.Scores(0.0, 0.0);

    public HITSWithPriors(Network<N, E> g, Function<E, ? extends Number> edge_weights, Function<N, HITS.Scores> node_priors, double alpha) {
        super(g, edge_weights, node_priors, alpha);
    }

    public HITSWithPriors(Network<N, E> g, Function<N, HITS.Scores> node_priors, double alpha) {
        super(g, (? super E n) -> 1.0, node_priors, alpha);
    }

    @Override
    protected double update(N v) {
        this.collectDisappearingPotential(v);
        double v_auth = 0.0;
        for (Object u : this.graph.predecessors(v)) {
            for (Object e : this.graph.edgesConnecting(u, v)) {
                v_auth += ((HITS.Scores)this.getCurrentValue(u)).hub * this.getEdgeWeight(u, e).doubleValue();
            }
        }
        double v_hub = 0.0;
        for (Object w : this.graph.successors(v)) {
            for (Object e : this.graph.edgesConnecting(v, w)) {
                v_hub += ((HITS.Scores)this.getCurrentValue(w)).authority * this.getEdgeWeight(w, e).doubleValue();
            }
        }
        if (this.alpha > 0.0) {
            v_auth = v_auth * (1.0 - this.alpha) + ((HITS.Scores)this.getNodePrior(v)).authority * this.alpha;
            v_hub = v_hub * (1.0 - this.alpha) + ((HITS.Scores)this.getNodePrior(v)).hub * this.alpha;
        }
        this.setOutputValue(v, new HITS.Scores(v_hub, v_auth));
        return Math.max(Math.abs(((HITS.Scores)this.getCurrentValue(v)).hub - v_hub), Math.abs(((HITS.Scores)this.getCurrentValue(v)).authority - v_auth));
    }

    @Override
    protected void afterStep() {
        if (this.disappearing_potential.hub > 0.0 || this.disappearing_potential.authority > 0.0) {
            for (Object v : this.graph.nodes()) {
                double new_hub = ((HITS.Scores)this.getOutputValue(v)).hub + (1.0 - this.alpha) * (this.disappearing_potential.hub * ((HITS.Scores)this.getNodePrior(v)).hub);
                double new_auth = ((HITS.Scores)this.getOutputValue(v)).authority + (1.0 - this.alpha) * (this.disappearing_potential.authority * ((HITS.Scores)this.getNodePrior(v)).authority);
                this.setOutputValue(v, new HITS.Scores(new_hub, new_auth));
            }
            this.disappearing_potential.hub = 0.0;
            this.disappearing_potential.authority = 0.0;
        }
        this.normalizeScores();
        super.afterStep();
    }

    protected void normalizeScores() {
        double hub_ssum = 0.0;
        double auth_ssum = 0.0;
        for (Object v : this.graph.nodes()) {
            double hub_val = ((HITS.Scores)this.getOutputValue(v)).hub;
            double auth_val = ((HITS.Scores)this.getOutputValue(v)).authority;
            hub_ssum += hub_val * hub_val;
            auth_ssum += auth_val * auth_val;
        }
        hub_ssum = Math.sqrt(hub_ssum);
        auth_ssum = Math.sqrt(auth_ssum);
        for (Object v : this.graph.nodes()) {
            HITS.Scores values = (HITS.Scores)this.getOutputValue(v);
            this.setOutputValue(v, new HITS.Scores(values.hub / hub_ssum, values.authority / auth_ssum));
        }
    }

    @Override
    protected void collectDisappearingPotential(N v) {
        if (this.graph.outDegree(v) == 0) {
            Preconditions.checkArgument((boolean)this.isDisconnectedGraphOK(), (Object)("Outdegree of " + v + " must be > 0"));
            this.disappearing_potential.hub += ((HITS.Scores)this.getCurrentValue(v)).authority;
        }
        if (this.graph.inDegree(v) == 0) {
            Preconditions.checkArgument((boolean)this.isDisconnectedGraphOK(), (Object)("Indegree of " + v + " must be > 0"));
            this.disappearing_potential.authority += ((HITS.Scores)this.getCurrentValue(v)).hub;
        }
    }
}

