/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.base.Preconditions;
import com.google.common.graph.Network;
import edu.uci.ics.jung.algorithms.scoring.PageRankWithPriors;
import edu.uci.ics.jung.algorithms.scoring.util.ScoringUtils;
import java.util.function.Function;

public class KStepMarkov<N, E>
extends PageRankWithPriors<N, E> {
    private boolean cumulative;

    public KStepMarkov(Network<N, E> graph, Function<E, ? extends Number> edge_weights, Function<N, Double> node_priors, int steps) {
        super(graph, edge_weights, node_priors, 0.0);
        this.initialize(steps);
    }

    public KStepMarkov(Network<N, E> graph, Function<N, Double> node_priors, int steps) {
        super(graph, node_priors, 0.0);
        this.initialize(steps);
    }

    public KStepMarkov(Network<N, E> graph, int steps) {
        super(graph, ScoringUtils.getUniformRootPrior(graph.nodes()), 0.0);
        this.initialize(steps);
    }

    private void initialize(int steps) {
        Preconditions.checkArgument((steps >= 0 ? 1 : 0) != 0, (Object)"Number of steps must be > 0");
        this.acceptDisconnectedGraph(false);
        this.max_iterations = steps;
        this.tolerance = -1.0;
        this.cumulative = false;
    }

    public void setCumulative(boolean cumulative) {
        this.cumulative = cumulative;
    }

    @Override
    public double update(N v) {
        if (!this.cumulative) {
            return super.update(v);
        }
        this.collectDisappearingPotential(v);
        double v_input = 0.0;
        for (Object u : this.graph.predecessors(v)) {
            for (Object e : this.graph.edgesConnecting(u, v)) {
                v_input += (Double)this.getCurrentValue(u) * this.getEdgeWeight(u, e).doubleValue();
            }
        }
        double new_value = this.alpha > 0.0 ? v_input * (1.0 - this.alpha) + (Double)this.getNodePrior(v) * this.alpha : v_input;
        this.setOutputValue(v, new_value + (Double)this.getCurrentValue(v));
        return Math.abs((Double)this.getCurrentValue(v) - new_value);
    }
}

