/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring.util;

import edu.uci.ics.jung.algorithms.scoring.HITS;
import java.util.Collection;
import java.util.function.Function;

public class ScoringUtils {
    public static <N> Function<N, Double> getUniformRootPrior(Collection<N> roots) {
        final Collection<N> inner_roots = roots;
        Function distribution = new Function<N, Double>(){

            @Override
            public Double apply(N input) {
                if (inner_roots.contains(input)) {
                    return new Double(1.0 / (double)inner_roots.size());
                }
                return 0.0;
            }
        };
        return distribution;
    }

    public static <N> Function<N, HITS.Scores> getHITSUniformRootPrior(Collection<N> roots) {
        final Collection<N> inner_roots = roots;
        Function distribution = new Function<N, HITS.Scores>(){

            @Override
            public HITS.Scores apply(N input) {
                if (inner_roots.contains(input)) {
                    return new HITS.Scores(1.0 / (double)inner_roots.size(), 1.0 / (double)inner_roots.size());
                }
                return new HITS.Scores(0.0, 0.0);
            }
        };
        return distribution;
    }
}

