/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import com.google.common.base.Preconditions;
import com.google.common.graph.Network;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraDistance;
import edu.uci.ics.jung.algorithms.shortestpath.ShortestPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DijkstraShortestPath<N, E>
extends DijkstraDistance<N, E>
implements ShortestPath<N, E> {
    public DijkstraShortestPath(Network<N, E> g, Function<E, ? extends Number> nev, boolean cached) {
        super(g, nev, cached);
    }

    public DijkstraShortestPath(Network<N, E> g, Function<E, ? extends Number> nev) {
        super(g, nev);
    }

    public DijkstraShortestPath(Network<N, E> g) {
        super(g);
    }

    public DijkstraShortestPath(Network<N, E> g, boolean cached) {
        super(g, cached);
    }

    @Override
    protected DijkstraDistance.SourceData getSourceData(N source) {
        DijkstraDistance.SourceData sd = (DijkstraDistance.SourceData)this.sourceMap.get(source);
        if (sd == null) {
            sd = new SourcePathData(source);
        }
        return sd;
    }

    public E getIncomingEdge(N source, N target) {
        Preconditions.checkArgument((boolean)this.g.nodes().contains(target), (String)"Specified target node %s  is not part of graph %s", target, (Object)this.g);
        Preconditions.checkArgument((boolean)this.g.nodes().contains(source), (String)"Specified source node %s  is not part of graph %s", source, (Object)this.g);
        HashSet<N> targets = new HashSet<N>();
        targets.add(target);
        this.singleSourceShortestPath(source, targets, this.g.nodes().size());
        LinkedHashMap incomingEdgeMap = ((SourcePathData)this.sourceMap.get(source)).incomingEdges;
        Object incomingEdge = incomingEdgeMap.get(target);
        if (!this.cached) {
            this.reset(source);
        }
        return (E)incomingEdge;
    }

    @Override
    public Map<N, E> getIncomingEdgeMap(N source) {
        return this.getIncomingEdgeMap(source, this.g.nodes().size());
    }

    public List<E> getPath(N source, N target) {
        Preconditions.checkArgument((boolean)this.g.nodes().contains(target), (String)"Specified target node %s  is not part of graph %s", target, (Object)this.g);
        Preconditions.checkArgument((boolean)this.g.nodes().contains(source), (String)"Specified source node %s  is not part of graph %s", source, (Object)this.g);
        LinkedList path = new LinkedList();
        HashSet<N> targets = new HashSet<N>();
        targets.add(target);
        this.singleSourceShortestPath(source, targets, this.g.nodes().size());
        LinkedHashMap incomingEdges = ((SourcePathData)this.sourceMap.get(source)).incomingEdges;
        if (incomingEdges.isEmpty() || incomingEdges.get(target) == null) {
            return path;
        }
        Object current = target;
        while (!current.equals(source)) {
            Object incoming = incomingEdges.get(current);
            path.addFirst(incoming);
            current = this.g.incidentNodes(incoming).adjacentNode(current);
        }
        if (!this.cached) {
            this.reset(source);
        }
        return new ArrayList(path);
    }

    public LinkedHashMap<N, E> getIncomingEdgeMap(N source, int numDests) {
        Preconditions.checkArgument((boolean)this.g.nodes().contains(source), (String)"Specified source node %s  is not part of graph %s", source, (Object)this.g);
        Preconditions.checkArgument((numDests >= 1 && numDests <= this.g.nodes().size() ? 1 : 0) != 0, (String)"number of destinations must be in [1, %d]", (int)this.g.nodes().size());
        this.singleSourceShortestPath(source, null, numDests);
        LinkedHashMap incomingEdgeMap = ((SourcePathData)this.sourceMap.get(source)).incomingEdges;
        if (!this.cached) {
            this.reset(source);
        }
        return incomingEdgeMap;
    }

    protected class SourcePathData
    extends DijkstraDistance.SourceData {
        protected Map<N, E> tentativeIncomingEdges;
        protected LinkedHashMap<N, E> incomingEdges;

        protected SourcePathData(N source) {
            super(source);
            this.incomingEdges = new LinkedHashMap();
            this.tentativeIncomingEdges = new HashMap();
        }

        @Override
        public void update(N dest, E tentative_edge, double new_dist) {
            super.update(dest, tentative_edge, new_dist);
            this.tentativeIncomingEdges.put(dest, tentative_edge);
        }

        @Override
        public Map.Entry<N, Number> getNextNode() {
            Map.Entry p = super.getNextNode();
            Object v = p.getKey();
            Object incoming = this.tentativeIncomingEdges.remove(v);
            this.incomingEdges.put(v, incoming);
            return p;
        }

        @Override
        public void restoreNode(N v, double dist) {
            super.restoreNode(v, dist);
            Object incoming = this.incomingEdges.get(v);
            this.tentativeIncomingEdges.put(v, incoming);
        }

        @Override
        public void createRecord(N w, E e, double new_dist) {
            super.createRecord(w, e, new_dist);
            this.tentativeIncomingEdges.put(w, e);
        }
    }
}

