/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.util;

import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;

public class MapBinaryHeap<T>
extends AbstractCollection<T>
implements Queue<T> {
    private List<T> heap = new ArrayList<T>();
    private Map<T, Integer> objectIndices = new HashMap<T, Integer>();
    private Comparator<? super T> comp;
    private static final int TOP = 0;

    public MapBinaryHeap(Comparator<T> comp) {
        this.initialize(comp);
    }

    public MapBinaryHeap() {
        this.initialize(new ComparableComparator());
    }

    public MapBinaryHeap(Collection<T> c) {
        this();
        this.addAll(c);
    }

    public MapBinaryHeap(Collection<T> c, Comparator<T> comp) {
        this(comp);
        this.addAll(c);
    }

    private void initialize(Comparator<T> comp) {
        this.comp = comp;
        this.clear();
    }

    @Override
    public void clear() {
        this.objectIndices.clear();
        this.heap.clear();
    }

    @Override
    public boolean add(T o) {
        int lastIndex = this.heap.size();
        this.heap.add(o);
        this.percolateUp(lastIndex, o);
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.heap.isEmpty();
    }

    @Override
    public T peek() {
        if (this.heap.size() > 0) {
            return this.heap.get(0);
        }
        return null;
    }

    @Override
    public int size() {
        return this.heap.size();
    }

    public void update(T o) {
        int cur = this.objectIndices.get(o);
        int newIdx = this.percolateUp(cur, o);
        this.percolateDown(newIdx);
    }

    @Override
    public boolean contains(Object o) {
        return this.objectIndices.containsKey(o);
    }

    private void percolateDown(int cur) {
        int left = this.lChild(cur);
        int right = this.rChild(cur);
        int smallest = left < this.heap.size() && this.comp.compare(this.heap.get(left), this.heap.get(cur)) < 0 ? left : cur;
        if (right < this.heap.size() && this.comp.compare(this.heap.get(right), this.heap.get(smallest)) < 0) {
            smallest = right;
        }
        if (cur != smallest) {
            this.swap(cur, smallest);
            this.percolateDown(smallest);
        }
    }

    private int percolateUp(int cur, T o) {
        int i = cur;
        while (i > 0 && this.comp.compare(this.heap.get(this.parent(i)), o) > 0) {
            T parentElt = this.heap.get(this.parent(i));
            this.heap.set(i, parentElt);
            this.objectIndices.put(parentElt, i);
            i = this.parent(i);
        }
        this.objectIndices.put(o, i);
        this.heap.set(i, o);
        return i;
    }

    private int lChild(int i) {
        return (i << 1) + 1;
    }

    private int rChild(int i) {
        return (i << 1) + 2;
    }

    private int parent(int i) {
        return i - 1 >> 1;
    }

    private void swap(int i, int j) {
        T iElt = this.heap.get(i);
        T jElt = this.heap.get(j);
        this.heap.set(i, jElt);
        this.objectIndices.put(jElt, i);
        this.heap.set(j, iElt);
        this.objectIndices.put(iElt, j);
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.unmodifiableIterator(this.heap.iterator());
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T element() {
        T top = this.peek();
        if (top == null) {
            throw new NoSuchElementException();
        }
        return top;
    }

    @Override
    public boolean offer(T o) {
        return this.add(o);
    }

    @Override
    public T poll() {
        T top = this.peek();
        if (top != null) {
            int lastIndex = this.heap.size() - 1;
            T bottom_elt = this.heap.get(lastIndex);
            this.heap.set(0, bottom_elt);
            this.objectIndices.put(bottom_elt, 0);
            this.heap.remove(lastIndex);
            if (this.heap.size() > 1) {
                this.percolateDown(0);
            }
            this.objectIndices.remove(top);
        }
        return top;
    }

    @Override
    public T remove() {
        T top = this.poll();
        if (top == null) {
            throw new NoSuchElementException();
        }
        return top;
    }

    private class ComparableComparator
    implements Comparator<T> {
        private ComparableComparator() {
        }

        @Override
        public int compare(T arg0, T arg1) {
            return ((Comparable)arg0).compareTo(arg1);
        }
    }
}

