/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.algorithms;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.graph.Graph;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.layout.algorithms.AbstractIterativeLayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.util.NetworkNodeAccessor;
import edu.uci.ics.jung.layout.util.RadiusNetworkNodeAccessor;
import edu.uci.ics.jung.layout.util.RandomLocationTransformer;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISOMLayoutAlgorithm<N>
extends AbstractIterativeLayoutAlgorithm<N>
implements IterativeContext {
    private static final Logger log = LoggerFactory.getLogger(ISOMLayoutAlgorithm.class);
    protected LoadingCache<N, ISOMNodeData> isomNodeData = CacheBuilder.newBuilder().build(new CacheLoader<N, ISOMNodeData>(){

        public ISOMNodeData load(N node) {
            return new ISOMNodeData();
        }
    });
    private int maxEpoch;
    private int epoch;
    private int radiusConstantTime;
    private int radius;
    private int minRadius;
    private double adaption;
    private double initialAdaption;
    private double minAdaption;
    private NetworkNodeAccessor<N> elementAccessor;
    private double coolingFactor;
    private List<N> queue = new ArrayList<N>();
    private String status = null;

    public String getStatus() {
        return this.status;
    }

    @Override
    public void visit(LayoutModel<N> layoutModel) {
        if (log.isTraceEnabled()) {
            log.trace("visiting {}", layoutModel);
        }
        super.visit(layoutModel);
        this.elementAccessor = new RadiusNetworkNodeAccessor();
        this.initialize();
    }

    public void initialize() {
        this.layoutModel.setInitializer(new RandomLocationTransformer(this.layoutModel.getWidth(), this.layoutModel.getHeight()));
        this.maxEpoch = 2000;
        this.epoch = 1;
        this.radiusConstantTime = 100;
        this.radius = 5;
        this.minRadius = 1;
        this.adaption = this.initialAdaption = 0.9;
        this.minAdaption = 0.0;
        this.coolingFactor = 2.0;
    }

    @Override
    public void step() {
        this.status = "epoch: " + this.epoch + "; ";
        if (this.epoch < this.maxEpoch) {
            this.adjust();
            this.updateParameters();
            this.status = this.status + " status: running";
        } else {
            this.status = this.status + "adaption: " + this.adaption + "; ";
            this.status = this.status + "status: done";
        }
    }

    private synchronized void adjust() {
        double width = this.layoutModel.getWidth();
        double height = this.layoutModel.getHeight();
        Point tempXYD = Point.of(10.0 + Math.random() * width, 10.0 + Math.random() * height);
        N winner = this.elementAccessor.getNode(this.layoutModel, tempXYD.x, tempXYD.y);
        while (true) {
            try {
                for (Object node : this.layoutModel.getGraph().nodes()) {
                    ISOMNodeData ivd = this.getISOMNodeData(node);
                    ivd.distance = 0;
                    ivd.visited = false;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        this.adjustNode(winner, tempXYD);
    }

    private synchronized void updateParameters() {
        ++this.epoch;
        double factor = Math.exp(-1.0 * this.coolingFactor * (1.0 * (double)this.epoch / (double)this.maxEpoch));
        this.adaption = Math.max(this.minAdaption, factor * this.initialAdaption);
        if (this.radius > this.minRadius && this.epoch % this.radiusConstantTime == 0) {
            --this.radius;
        }
    }

    private synchronized void adjustNode(N node, Point tempXYD) {
        Graph graph = this.layoutModel.getGraph();
        this.queue.clear();
        ISOMNodeData ivd = this.getISOMNodeData(node);
        ivd.distance = 0;
        ivd.visited = true;
        this.queue.add(node);
        block2: while (!this.queue.isEmpty()) {
            N current = this.queue.remove(0);
            ISOMNodeData currData = this.getISOMNodeData(current);
            Point currXYData = (Point)this.layoutModel.apply(current);
            double dx = tempXYD.x - currXYData.x;
            double dy = tempXYD.y - currXYData.y;
            double factor = this.adaption / Math.pow(2.0, currData.distance);
            this.layoutModel.set(current, currXYData.x + factor * dx, currXYData.y + factor * dy);
            if (currData.distance >= this.radius) continue;
            Set s = graph.adjacentNodes(current);
            while (true) {
                try {
                    for (Object child : s) {
                        ISOMNodeData childData = this.getISOMNodeData(child);
                        if (childData == null || childData.visited) continue;
                        childData.visited = true;
                        childData.distance = currData.distance + 1;
                        this.queue.add(child);
                    }
                    continue block2;
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
                break;
            }
        }
    }

    protected ISOMNodeData getISOMNodeData(N node) {
        return (ISOMNodeData)this.isomNodeData.getUnchecked(node);
    }

    @Override
    public boolean done() {
        return this.epoch >= this.maxEpoch;
    }

    public void reset() {
        this.epoch = 0;
    }

    protected static class ISOMNodeData {
        int distance = 0;
        boolean visited = false;

        protected ISOMNodeData() {
        }
    }
}

