/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.algorithms;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.layout.algorithms.SpringLayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.spatial.BarnesHutQuadTree;
import edu.uci.ics.jung.layout.spatial.ForceObject;
import java.util.ConcurrentModificationException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringBHVisitorLayoutAlgorithm<N>
extends SpringLayoutAlgorithm<N>
implements IterativeContext {
    private static final Logger log = LoggerFactory.getLogger(SpringBHVisitorLayoutAlgorithm.class);
    private BarnesHutQuadTree<N> tree;

    public SpringBHVisitorLayoutAlgorithm() {
    }

    public SpringBHVisitorLayoutAlgorithm(Function<? super EndpointPair<N>, Integer> length_function) {
        super(length_function);
    }

    @Override
    public void visit(LayoutModel<N> layoutModel) {
        super.visit(layoutModel);
        this.tree = new BarnesHutQuadTree(layoutModel.getWidth(), layoutModel.getHeight());
    }

    @Override
    public void step() {
        this.tree.rebuild(this.layoutModel.getLocations());
        super.step();
    }

    @Override
    protected void calculateRepulsion() {
        Graph graph = this.layoutModel.getGraph();
        try {
            for (final Object node : graph.nodes()) {
                SpringLayoutAlgorithm.SpringNodeData svd;
                if (this.layoutModel.isLocked(node) || (svd = (SpringLayoutAlgorithm.SpringNodeData)this.springNodeData.getUnchecked(node)) == null) continue;
                ForceObject nodeForceObject = new ForceObject(node, (Point)this.layoutModel.apply(node)){

                    protected void addForceFrom(ForceObject other) {
                        if (other == null || node == other.getElement()) {
                            return;
                        }
                        Point p = this.p;
                        Point p2 = other.p;
                        if (p == null || p2 == null) {
                            return;
                        }
                        double vx = p.x - p2.x;
                        double vy = p.y - p2.y;
                        double distanceSq = p.distanceSquared(p2);
                        if (distanceSq == 0.0) {
                            this.f = this.f.add(SpringBHVisitorLayoutAlgorithm.this.random.nextDouble(), SpringBHVisitorLayoutAlgorithm.this.random.nextDouble());
                        } else if (distanceSq < (double)SpringBHVisitorLayoutAlgorithm.this.repulsion_range_sq) {
                            double factor = 1.0;
                            this.f = this.f.add(factor * vx / distanceSq, factor * vy / distanceSq);
                        }
                    }
                };
                this.tree.applyForcesTo(nodeForceObject);
                Point f = nodeForceObject.f;
                double dlen = f.x * f.x + f.y * f.y;
                if (!(dlen > 0.0)) continue;
                dlen = Math.sqrt(dlen) / 2.0;
                svd.repulsiondx += f.x / dlen;
                svd.repulsiondy += f.y / dlen;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.calculateRepulsion();
        }
    }
}

