/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.model;

import com.google.common.collect.Lists;
import edu.uci.ics.jung.layout.model.LayoutModel;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLayoutStateChangeSupport
implements LayoutModel.LayoutStateChangeSupport {
    private static final Logger log = LoggerFactory.getLogger(DefaultLayoutStateChangeSupport.class);
    protected boolean fireEvents;
    protected List<LayoutModel.LayoutStateChangeListener> changeListeners = Collections.synchronizedList(Lists.newArrayList());

    @Override
    public boolean isFireEvents() {
        return this.fireEvents;
    }

    @Override
    public void setFireEvents(boolean fireEvents) {
        this.fireEvents = fireEvents;
    }

    @Override
    public void addLayoutStateChangeListener(LayoutModel.LayoutStateChangeListener l) {
        this.changeListeners.add(l);
    }

    @Override
    public void removeLayoutStateChangeListener(LayoutModel.LayoutStateChangeListener l) {
        this.changeListeners.remove(l);
    }

    @Override
    public List<LayoutModel.LayoutStateChangeListener> getLayoutStateChangeListeners() {
        return this.changeListeners;
    }

    @Override
    public void fireLayoutStateChanged(LayoutModel layoutModel, boolean state) {
        log.trace("fireLayoutStateChange to {}", (Object)state);
        if (this.changeListeners.size() > 0) {
            LayoutModel.LayoutStateChangeEvent evt = new LayoutModel.LayoutStateChangeEvent(layoutModel, state);
            for (LayoutModel.LayoutStateChangeListener listener : this.changeListeners) {
                listener.layoutStateChanged(evt);
            }
        } else {
            log.trace("there are no listeners for {}", (Object)this);
        }
    }
}

