/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.model;

import com.google.common.collect.Maps;
import com.google.common.graph.Graph;
import edu.uci.ics.jung.layout.algorithms.LayoutAlgorithm;
import edu.uci.ics.jung.layout.model.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public interface LayoutModel<N>
extends Function<N, Point> {
    public int getWidth();

    public int getHeight();

    public void accept(LayoutAlgorithm<N> var1);

    default public Map<N, Point> getLocations() {
        return Collections.unmodifiableMap(Maps.asMap((Set)this.getGraph().nodes(), this::apply));
    }

    public void setSize(int var1, int var2);

    public void stopRelaxer();

    public void setRelaxing(boolean var1);

    public boolean isRelaxing();

    public CompletableFuture getTheFuture();

    public boolean isLocked(N var1);

    public void set(N var1, Point var2);

    public void set(N var1, double var2, double var4);

    public Point get(N var1);

    public Graph<N> getGraph();

    public void setGraph(Graph<N> var1);

    public void lock(N var1, boolean var2);

    public void lock(boolean var1);

    public boolean isLocked();

    public void setInitializer(Function<N, Point> var1);

    public ChangeSupport getChangeSupport();

    public LayoutStateChangeSupport getLayoutStateChangeSupport();

    public static interface LayoutStateChangeListener {
        public void layoutStateChanged(LayoutStateChangeEvent var1);
    }

    public static class LayoutStateChangeEvent {
        public final LayoutModel layoutModel;
        public final boolean active;

        public LayoutStateChangeEvent(LayoutModel layoutModel, boolean active) {
            this.layoutModel = layoutModel;
            this.active = active;
        }

        public String toString() {
            return "LayoutStateChangeEvent{layoutModel=" + this.layoutModel + ", active=" + this.active + '}';
        }
    }

    public static interface LayoutStateChangeSupport {
        public boolean isFireEvents();

        public void setFireEvents(boolean var1);

        public void addLayoutStateChangeListener(LayoutStateChangeListener var1);

        public void removeLayoutStateChangeListener(LayoutStateChangeListener var1);

        public void fireLayoutStateChanged(LayoutModel var1, boolean var2);

        public List<LayoutStateChangeListener> getLayoutStateChangeListeners();
    }

    public static interface ChangeSupport {
        public boolean isFireEvents();

        public void setFireEvents(boolean var1);

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);

        public void fireChanged();

        public Collection<ChangeListener> getChangeListeners();
    }

    public static interface ChangeListener {
        public void changed();
    }
}

