/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.spatial;

import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.spatial.Rectangle;

public class Circle {
    public final Point center;
    public final double radius;

    public Circle(Point center, double radius) {
        this.center = center;
        this.radius = radius;
    }

    public boolean contains(Point p) {
        return p.inside(this.center.x - this.radius, this.center.y - this.radius, this.center.x + this.radius, this.center.y + this.radius) && this.center.distance(p) <= this.radius;
    }

    public boolean intersects(Rectangle r) {
        return r.maxX >= this.center.x - this.radius && r.maxY >= this.center.y - this.radius && r.x <= this.center.x + this.radius && r.y <= this.center.y + this.radius && this.squaredDistance(this.center, r) < this.radius * this.radius;
    }

    private double squaredDistance(Point p, Rectangle r) {
        double cy;
        double distSq = 0.0;
        double cx = p.x;
        if (cx < r.x) {
            distSq += (r.x - cx) * (r.x - cx);
        }
        if (cx > r.maxX) {
            distSq += (cx - r.maxX) * (cx - r.maxX);
        }
        if ((cy = p.y) < r.y) {
            distSq += (r.y - cy) * (r.y - cy);
        }
        if (cy > r.maxY) {
            distSq += (cy - r.maxY) * (cy - r.maxY);
        }
        return distSq;
    }
}

