/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Network;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.function.Function;

public class PajekNetWriter<N, E> {
    public void save(Network<N, E> g, String filename, Function<N, String> vs, Function<E, Number> nev, Function<N, Point2D> vld) throws IOException {
        this.save(g, new FileWriter(filename), vs, nev, vld);
    }

    public void save(Network<N, E> g, String filename, Function<N, String> vs, Function<E, Number> nev) throws IOException {
        this.save(g, new FileWriter(filename), vs, nev, null);
    }

    public void save(Network<N, E> g, String filename) throws IOException {
        this.save(g, filename, null, null, null);
    }

    public void save(Network<N, E> g, Writer w) throws IOException {
        this.save(g, w, null, null, null);
    }

    public void save(Network<N, E> g, Writer w, Function<N, String> vs, Function<E, Number> nev) throws IOException {
        this.save(g, w, vs, nev, null);
    }

    public void save(Network<N, E> graph, Writer w, Function<N, String> vs, Function<E, Number> nev, Function<N, Point2D> vld) throws IOException {
        BufferedWriter writer = new BufferedWriter(w);
        if (nev == null) {
            nev = new Function<E, Number>(){

                @Override
                public Number apply(E e) {
                    return 1;
                }
            };
        }
        writer.write("*Nodes " + graph.nodes().size());
        writer.newLine();
        ArrayList id = new ArrayList(graph.nodes());
        for (Object currentNode : graph.nodes()) {
            Point2D location;
            String label;
            int v_id = id.indexOf(currentNode) + 1;
            writer.write("" + v_id);
            if (vs != null && (label = vs.apply(currentNode)) != null) {
                writer.write(" \"" + label + "\"");
            }
            if (vld != null && (location = vld.apply(currentNode)) != null) {
                writer.write(" " + location.getX() + " " + location.getY() + " 0.0");
            }
            writer.newLine();
        }
        writer.write(graph.isDirected() ? "*Arcs" : "*Edges");
        writer.newLine();
        for (Object e : graph.edges()) {
            EndpointPair endpoints = graph.incidentNodes(e);
            int nodeU_id = id.indexOf(endpoints.nodeU()) + 1;
            int nodeV_id = id.indexOf(endpoints.nodeV()) + 1;
            float weight = ((Number)nev.apply(e)).floatValue();
            writer.write(nodeU_id + " " + nodeV_id + " " + weight);
            writer.newLine();
        }
        writer.close();
    }
}

