/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.Metadata;
import edu.uci.ics.jung.io.graphml.parser.ElementParser;
import edu.uci.ics.jung.io.graphml.parser.ParserContext;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;

public abstract class AbstractElementParser<G extends MutableNetwork<N, E>, N, E>
implements ElementParser {
    private final ParserContext<G, N, E> parserContext;

    protected AbstractElementParser(ParserContext<G, N, E> parserContext) {
        this.parserContext = parserContext;
    }

    public ParserContext<G, N, E> getParserContext() {
        return this.parserContext;
    }

    public ElementParser getParser(String localName) {
        return this.parserContext.getElementParserRegistry().getParser(localName);
    }

    public void applyKeys(Metadata metadata) {
        this.getParserContext().getKeyMap().applyKeys(metadata);
    }

    public ElementParser getUnknownParser() {
        return this.parserContext.getElementParserRegistry().getUnknownElementParser();
    }

    protected void verifyMatch(StartElement start, EndElement end) throws GraphIOException {
        String endName;
        String startName = start.getName().getLocalPart();
        if (!startName.equals(endName = end.getName().getLocalPart())) {
            throw new GraphIOException("Failed parsing document: Start/end tag mismatch! StartTag:" + startName + ", EndTag: " + endName);
        }
    }
}

