/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.io.graphml.EdgeMetadata;
import edu.uci.ics.jung.io.graphml.GraphMetadata;
import edu.uci.ics.jung.io.graphml.KeyMap;
import edu.uci.ics.jung.io.graphml.NodeMetadata;
import edu.uci.ics.jung.io.graphml.parser.ElementParserRegistry;
import java.util.function.Function;

public class ParserContext<G extends MutableNetwork<N, E>, N, E> {
    private final KeyMap keyMap;
    private final ElementParserRegistry<G, N, E> elementParserRegistry;
    private final Function<GraphMetadata, G> graphTransformer;
    private final Function<NodeMetadata, N> nodeTransformer;
    private final Function<EdgeMetadata, E> edgeTransformer;

    public ParserContext(ElementParserRegistry<G, N, E> elementParserRegistry, KeyMap keyMap, Function<GraphMetadata, G> graphTransformer, Function<NodeMetadata, N> nodeTransformer, Function<EdgeMetadata, E> edgeTransformer) {
        this.elementParserRegistry = elementParserRegistry;
        this.keyMap = keyMap;
        this.graphTransformer = graphTransformer;
        this.nodeTransformer = nodeTransformer;
        this.edgeTransformer = edgeTransformer;
    }

    public ElementParserRegistry<G, N, E> getElementParserRegistry() {
        return this.elementParserRegistry;
    }

    public KeyMap getKeyMap() {
        return this.keyMap;
    }

    public G createGraph(GraphMetadata metadata) {
        return (G)((MutableNetwork)this.graphTransformer.apply(metadata));
    }

    public N createNode(NodeMetadata metadata) {
        return this.nodeTransformer.apply(metadata);
    }

    public E createEdge(EdgeMetadata metadata) {
        return this.edgeTransformer.apply(metadata);
    }
}

